/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.elasticache.model.DeleteReplicationGroupRequest;

public class DeleteReplicationGroupRequestMarshaller
implements Marshaller<Request<DeleteReplicationGroupRequest>, DeleteReplicationGroupRequest> {
    public Request<DeleteReplicationGroupRequest> marshall(DeleteReplicationGroupRequest deleteReplicationGroupRequest) {
        if (deleteReplicationGroupRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)deleteReplicationGroupRequest, "ElastiCacheClient");
        request.addParameter("Action", "DeleteReplicationGroup");
        request.addParameter("Version", "2015-02-02");
        request.setHttpMethod(HttpMethodName.POST);
        if (deleteReplicationGroupRequest.replicationGroupId() != null) {
            request.addParameter("ReplicationGroupId", StringConversion.fromString((String)deleteReplicationGroupRequest.replicationGroupId()));
        }
        if (deleteReplicationGroupRequest.retainPrimaryCluster() != null) {
            request.addParameter("RetainPrimaryCluster", StringConversion.fromBoolean((Boolean)deleteReplicationGroupRequest.retainPrimaryCluster()));
        }
        if (deleteReplicationGroupRequest.finalSnapshotIdentifier() != null) {
            request.addParameter("FinalSnapshotIdentifier", StringConversion.fromString((String)deleteReplicationGroupRequest.finalSnapshotIdentifier()));
        }
        return request;
    }
}

