/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.elasticache.model.CreateSnapshotRequest;

public class CreateSnapshotRequestMarshaller
implements Marshaller<Request<CreateSnapshotRequest>, CreateSnapshotRequest> {
    public Request<CreateSnapshotRequest> marshall(CreateSnapshotRequest createSnapshotRequest) {
        if (createSnapshotRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)createSnapshotRequest, "ElastiCacheClient");
        request.addParameter("Action", "CreateSnapshot");
        request.addParameter("Version", "2015-02-02");
        request.setHttpMethod(HttpMethodName.POST);
        if (createSnapshotRequest.replicationGroupId() != null) {
            request.addParameter("ReplicationGroupId", StringConversion.fromString((String)createSnapshotRequest.replicationGroupId()));
        }
        if (createSnapshotRequest.cacheClusterId() != null) {
            request.addParameter("CacheClusterId", StringConversion.fromString((String)createSnapshotRequest.cacheClusterId()));
        }
        if (createSnapshotRequest.snapshotName() != null) {
            request.addParameter("SnapshotName", StringConversion.fromString((String)createSnapshotRequest.snapshotName()));
        }
        return request;
    }
}

