/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.elasticache.model.CreateReplicationGroupRequest;
import software.amazon.awssdk.services.elasticache.model.NodeGroupConfiguration;
import software.amazon.awssdk.services.elasticache.model.Tag;

public class CreateReplicationGroupRequestMarshaller
implements Marshaller<Request<CreateReplicationGroupRequest>, CreateReplicationGroupRequest> {
    public Request<CreateReplicationGroupRequest> marshall(CreateReplicationGroupRequest createReplicationGroupRequest) {
        if (createReplicationGroupRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)createReplicationGroupRequest, "ElastiCacheClient");
        request.addParameter("Action", "CreateReplicationGroup");
        request.addParameter("Version", "2015-02-02");
        request.setHttpMethod(HttpMethodName.POST);
        if (createReplicationGroupRequest.replicationGroupId() != null) {
            request.addParameter("ReplicationGroupId", StringConversion.fromString((String)createReplicationGroupRequest.replicationGroupId()));
        }
        if (createReplicationGroupRequest.replicationGroupDescription() != null) {
            request.addParameter("ReplicationGroupDescription", StringConversion.fromString((String)createReplicationGroupRequest.replicationGroupDescription()));
        }
        if (createReplicationGroupRequest.primaryClusterId() != null) {
            request.addParameter("PrimaryClusterId", StringConversion.fromString((String)createReplicationGroupRequest.primaryClusterId()));
        }
        if (createReplicationGroupRequest.automaticFailoverEnabled() != null) {
            request.addParameter("AutomaticFailoverEnabled", StringConversion.fromBoolean((Boolean)createReplicationGroupRequest.automaticFailoverEnabled()));
        }
        if (createReplicationGroupRequest.numCacheClusters() != null) {
            request.addParameter("NumCacheClusters", StringConversion.fromInteger((Integer)createReplicationGroupRequest.numCacheClusters()));
        }
        if (createReplicationGroupRequest.preferredCacheClusterAZs().isEmpty() && !(createReplicationGroupRequest.preferredCacheClusterAZs() instanceof SdkAutoConstructList)) {
            request.addParameter("PreferredCacheClusterAZs", "");
        } else if (!createReplicationGroupRequest.preferredCacheClusterAZs().isEmpty() && !(createReplicationGroupRequest.preferredCacheClusterAZs() instanceof SdkAutoConstructList)) {
            List<String> preferredCacheClusterAZsList = createReplicationGroupRequest.preferredCacheClusterAZs();
            int preferredCacheClusterAZsListIndex = 1;
            for (String preferredCacheClusterAZsListValue : preferredCacheClusterAZsList) {
                if (preferredCacheClusterAZsListValue != null) {
                    request.addParameter("PreferredCacheClusterAZs.AvailabilityZone." + preferredCacheClusterAZsListIndex, StringConversion.fromString((String)preferredCacheClusterAZsListValue));
                }
                ++preferredCacheClusterAZsListIndex;
            }
        }
        if (createReplicationGroupRequest.numNodeGroups() != null) {
            request.addParameter("NumNodeGroups", StringConversion.fromInteger((Integer)createReplicationGroupRequest.numNodeGroups()));
        }
        if (createReplicationGroupRequest.replicasPerNodeGroup() != null) {
            request.addParameter("ReplicasPerNodeGroup", StringConversion.fromInteger((Integer)createReplicationGroupRequest.replicasPerNodeGroup()));
        }
        if (createReplicationGroupRequest.nodeGroupConfiguration().isEmpty() && !(createReplicationGroupRequest.nodeGroupConfiguration() instanceof SdkAutoConstructList)) {
            request.addParameter("NodeGroupConfiguration", "");
        } else if (!createReplicationGroupRequest.nodeGroupConfiguration().isEmpty() && !(createReplicationGroupRequest.nodeGroupConfiguration() instanceof SdkAutoConstructList)) {
            List<NodeGroupConfiguration> nodeGroupConfigurationList = createReplicationGroupRequest.nodeGroupConfiguration();
            int nodeGroupConfigurationListIndex = 1;
            for (NodeGroupConfiguration nodeGroupConfigurationListValue : nodeGroupConfigurationList) {
                if (nodeGroupConfigurationListValue.nodeGroupId() != null) {
                    request.addParameter("NodeGroupConfiguration.NodeGroupConfiguration." + nodeGroupConfigurationListIndex + ".NodeGroupId", StringConversion.fromString((String)nodeGroupConfigurationListValue.nodeGroupId()));
                }
                if (nodeGroupConfigurationListValue.slots() != null) {
                    request.addParameter("NodeGroupConfiguration.NodeGroupConfiguration." + nodeGroupConfigurationListIndex + ".Slots", StringConversion.fromString((String)nodeGroupConfigurationListValue.slots()));
                }
                if (nodeGroupConfigurationListValue.replicaCount() != null) {
                    request.addParameter("NodeGroupConfiguration.NodeGroupConfiguration." + nodeGroupConfigurationListIndex + ".ReplicaCount", StringConversion.fromInteger((Integer)nodeGroupConfigurationListValue.replicaCount()));
                }
                if (nodeGroupConfigurationListValue.primaryAvailabilityZone() != null) {
                    request.addParameter("NodeGroupConfiguration.NodeGroupConfiguration." + nodeGroupConfigurationListIndex + ".PrimaryAvailabilityZone", StringConversion.fromString((String)nodeGroupConfigurationListValue.primaryAvailabilityZone()));
                }
                if (nodeGroupConfigurationListValue.replicaAvailabilityZones().isEmpty() && !(nodeGroupConfigurationListValue.replicaAvailabilityZones() instanceof SdkAutoConstructList)) {
                    request.addParameter("NodeGroupConfiguration.NodeGroupConfiguration." + nodeGroupConfigurationListIndex + ".ReplicaAvailabilityZones", "");
                } else if (!nodeGroupConfigurationListValue.replicaAvailabilityZones().isEmpty() && !(nodeGroupConfigurationListValue.replicaAvailabilityZones() instanceof SdkAutoConstructList)) {
                    List<String> replicaAvailabilityZonesList = nodeGroupConfigurationListValue.replicaAvailabilityZones();
                    int replicaAvailabilityZonesListIndex = 1;
                    for (String replicaAvailabilityZonesListValue : replicaAvailabilityZonesList) {
                        if (replicaAvailabilityZonesListValue != null) {
                            request.addParameter("NodeGroupConfiguration.NodeGroupConfiguration." + nodeGroupConfigurationListIndex + ".ReplicaAvailabilityZones.AvailabilityZone." + replicaAvailabilityZonesListIndex, StringConversion.fromString((String)replicaAvailabilityZonesListValue));
                        }
                        ++replicaAvailabilityZonesListIndex;
                    }
                }
                ++nodeGroupConfigurationListIndex;
            }
        }
        if (createReplicationGroupRequest.cacheNodeType() != null) {
            request.addParameter("CacheNodeType", StringConversion.fromString((String)createReplicationGroupRequest.cacheNodeType()));
        }
        if (createReplicationGroupRequest.engine() != null) {
            request.addParameter("Engine", StringConversion.fromString((String)createReplicationGroupRequest.engine()));
        }
        if (createReplicationGroupRequest.engineVersion() != null) {
            request.addParameter("EngineVersion", StringConversion.fromString((String)createReplicationGroupRequest.engineVersion()));
        }
        if (createReplicationGroupRequest.cacheParameterGroupName() != null) {
            request.addParameter("CacheParameterGroupName", StringConversion.fromString((String)createReplicationGroupRequest.cacheParameterGroupName()));
        }
        if (createReplicationGroupRequest.cacheSubnetGroupName() != null) {
            request.addParameter("CacheSubnetGroupName", StringConversion.fromString((String)createReplicationGroupRequest.cacheSubnetGroupName()));
        }
        if (createReplicationGroupRequest.cacheSecurityGroupNames().isEmpty() && !(createReplicationGroupRequest.cacheSecurityGroupNames() instanceof SdkAutoConstructList)) {
            request.addParameter("CacheSecurityGroupNames", "");
        } else if (!createReplicationGroupRequest.cacheSecurityGroupNames().isEmpty() && !(createReplicationGroupRequest.cacheSecurityGroupNames() instanceof SdkAutoConstructList)) {
            List<String> cacheSecurityGroupNamesList = createReplicationGroupRequest.cacheSecurityGroupNames();
            int cacheSecurityGroupNamesListIndex = 1;
            for (String cacheSecurityGroupNamesListValue : cacheSecurityGroupNamesList) {
                if (cacheSecurityGroupNamesListValue != null) {
                    request.addParameter("CacheSecurityGroupNames.CacheSecurityGroupName." + cacheSecurityGroupNamesListIndex, StringConversion.fromString((String)cacheSecurityGroupNamesListValue));
                }
                ++cacheSecurityGroupNamesListIndex;
            }
        }
        if (createReplicationGroupRequest.securityGroupIds().isEmpty() && !(createReplicationGroupRequest.securityGroupIds() instanceof SdkAutoConstructList)) {
            request.addParameter("SecurityGroupIds", "");
        } else if (!createReplicationGroupRequest.securityGroupIds().isEmpty() && !(createReplicationGroupRequest.securityGroupIds() instanceof SdkAutoConstructList)) {
            List<String> securityGroupIdsList = createReplicationGroupRequest.securityGroupIds();
            int securityGroupIdsListIndex = 1;
            for (String securityGroupIdsListValue : securityGroupIdsList) {
                if (securityGroupIdsListValue != null) {
                    request.addParameter("SecurityGroupIds.SecurityGroupId." + securityGroupIdsListIndex, StringConversion.fromString((String)securityGroupIdsListValue));
                }
                ++securityGroupIdsListIndex;
            }
        }
        if (createReplicationGroupRequest.tags().isEmpty() && !(createReplicationGroupRequest.tags() instanceof SdkAutoConstructList)) {
            request.addParameter("Tags", "");
        } else if (!createReplicationGroupRequest.tags().isEmpty() && !(createReplicationGroupRequest.tags() instanceof SdkAutoConstructList)) {
            List<Tag> tagsList = createReplicationGroupRequest.tags();
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue.key() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Key", StringConversion.fromString((String)tagsListValue.key()));
                }
                if (tagsListValue.value() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Value", StringConversion.fromString((String)tagsListValue.value()));
                }
                ++tagsListIndex;
            }
        }
        if (createReplicationGroupRequest.snapshotArns().isEmpty() && !(createReplicationGroupRequest.snapshotArns() instanceof SdkAutoConstructList)) {
            request.addParameter("SnapshotArns", "");
        } else if (!createReplicationGroupRequest.snapshotArns().isEmpty() && !(createReplicationGroupRequest.snapshotArns() instanceof SdkAutoConstructList)) {
            List<String> snapshotArnsList = createReplicationGroupRequest.snapshotArns();
            int snapshotArnsListIndex = 1;
            for (String snapshotArnsListValue : snapshotArnsList) {
                if (snapshotArnsListValue != null) {
                    request.addParameter("SnapshotArns.SnapshotArn." + snapshotArnsListIndex, StringConversion.fromString((String)snapshotArnsListValue));
                }
                ++snapshotArnsListIndex;
            }
        }
        if (createReplicationGroupRequest.snapshotName() != null) {
            request.addParameter("SnapshotName", StringConversion.fromString((String)createReplicationGroupRequest.snapshotName()));
        }
        if (createReplicationGroupRequest.preferredMaintenanceWindow() != null) {
            request.addParameter("PreferredMaintenanceWindow", StringConversion.fromString((String)createReplicationGroupRequest.preferredMaintenanceWindow()));
        }
        if (createReplicationGroupRequest.port() != null) {
            request.addParameter("Port", StringConversion.fromInteger((Integer)createReplicationGroupRequest.port()));
        }
        if (createReplicationGroupRequest.notificationTopicArn() != null) {
            request.addParameter("NotificationTopicArn", StringConversion.fromString((String)createReplicationGroupRequest.notificationTopicArn()));
        }
        if (createReplicationGroupRequest.autoMinorVersionUpgrade() != null) {
            request.addParameter("AutoMinorVersionUpgrade", StringConversion.fromBoolean((Boolean)createReplicationGroupRequest.autoMinorVersionUpgrade()));
        }
        if (createReplicationGroupRequest.snapshotRetentionLimit() != null) {
            request.addParameter("SnapshotRetentionLimit", StringConversion.fromInteger((Integer)createReplicationGroupRequest.snapshotRetentionLimit()));
        }
        if (createReplicationGroupRequest.snapshotWindow() != null) {
            request.addParameter("SnapshotWindow", StringConversion.fromString((String)createReplicationGroupRequest.snapshotWindow()));
        }
        if (createReplicationGroupRequest.authToken() != null) {
            request.addParameter("AuthToken", StringConversion.fromString((String)createReplicationGroupRequest.authToken()));
        }
        if (createReplicationGroupRequest.transitEncryptionEnabled() != null) {
            request.addParameter("TransitEncryptionEnabled", StringConversion.fromBoolean((Boolean)createReplicationGroupRequest.transitEncryptionEnabled()));
        }
        if (createReplicationGroupRequest.atRestEncryptionEnabled() != null) {
            request.addParameter("AtRestEncryptionEnabled", StringConversion.fromBoolean((Boolean)createReplicationGroupRequest.atRestEncryptionEnabled()));
        }
        return request;
    }
}

