/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.elasticache.model.CreateCacheSecurityGroupRequest;

public class CreateCacheSecurityGroupRequestMarshaller
implements Marshaller<Request<CreateCacheSecurityGroupRequest>, CreateCacheSecurityGroupRequest> {
    public Request<CreateCacheSecurityGroupRequest> marshall(CreateCacheSecurityGroupRequest createCacheSecurityGroupRequest) {
        if (createCacheSecurityGroupRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)createCacheSecurityGroupRequest, "ElastiCacheClient");
        request.addParameter("Action", "CreateCacheSecurityGroup");
        request.addParameter("Version", "2015-02-02");
        request.setHttpMethod(HttpMethodName.POST);
        if (createCacheSecurityGroupRequest.cacheSecurityGroupName() != null) {
            request.addParameter("CacheSecurityGroupName", StringConversion.fromString((String)createCacheSecurityGroupRequest.cacheSecurityGroupName()));
        }
        if (createCacheSecurityGroupRequest.description() != null) {
            request.addParameter("Description", StringConversion.fromString((String)createCacheSecurityGroupRequest.description()));
        }
        return request;
    }
}

