/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.elasticache.model.ChangeType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Parameter
implements ToCopyableBuilder<Builder, Parameter> {
    private final String parameterName;
    private final String parameterValue;
    private final String description;
    private final String source;
    private final String dataType;
    private final String allowedValues;
    private final Boolean isModifiable;
    private final String minimumEngineVersion;
    private final String changeType;

    private Parameter(BuilderImpl builder) {
        this.parameterName = builder.parameterName;
        this.parameterValue = builder.parameterValue;
        this.description = builder.description;
        this.source = builder.source;
        this.dataType = builder.dataType;
        this.allowedValues = builder.allowedValues;
        this.isModifiable = builder.isModifiable;
        this.minimumEngineVersion = builder.minimumEngineVersion;
        this.changeType = builder.changeType;
    }

    public String parameterName() {
        return this.parameterName;
    }

    public String parameterValue() {
        return this.parameterValue;
    }

    public String description() {
        return this.description;
    }

    public String source() {
        return this.source;
    }

    public String dataType() {
        return this.dataType;
    }

    public String allowedValues() {
        return this.allowedValues;
    }

    public Boolean isModifiable() {
        return this.isModifiable;
    }

    public String minimumEngineVersion() {
        return this.minimumEngineVersion;
    }

    public ChangeType changeType() {
        return ChangeType.fromValue(this.changeType);
    }

    public String changeTypeAsString() {
        return this.changeType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.parameterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameterValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataType());
        hashCode = 31 * hashCode + Objects.hashCode(this.allowedValues());
        hashCode = 31 * hashCode + Objects.hashCode(this.isModifiable());
        hashCode = 31 * hashCode + Objects.hashCode(this.minimumEngineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.changeTypeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Parameter)) {
            return false;
        }
        Parameter other = (Parameter)obj;
        return Objects.equals(this.parameterName(), other.parameterName()) && Objects.equals(this.parameterValue(), other.parameterValue()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.source(), other.source()) && Objects.equals(this.dataType(), other.dataType()) && Objects.equals(this.allowedValues(), other.allowedValues()) && Objects.equals(this.isModifiable(), other.isModifiable()) && Objects.equals(this.minimumEngineVersion(), other.minimumEngineVersion()) && Objects.equals(this.changeTypeAsString(), other.changeTypeAsString());
    }

    public String toString() {
        return ToString.builder((String)"Parameter").add("ParameterName", (Object)this.parameterName()).add("ParameterValue", (Object)this.parameterValue()).add("Description", (Object)this.description()).add("Source", (Object)this.source()).add("DataType", (Object)this.dataType()).add("AllowedValues", (Object)this.allowedValues()).add("IsModifiable", (Object)this.isModifiable()).add("MinimumEngineVersion", (Object)this.minimumEngineVersion()).add("ChangeType", (Object)this.changeTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ParameterName": {
                return Optional.ofNullable(clazz.cast(this.parameterName()));
            }
            case "ParameterValue": {
                return Optional.ofNullable(clazz.cast(this.parameterValue()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
            case "DataType": {
                return Optional.ofNullable(clazz.cast(this.dataType()));
            }
            case "AllowedValues": {
                return Optional.ofNullable(clazz.cast(this.allowedValues()));
            }
            case "IsModifiable": {
                return Optional.ofNullable(clazz.cast(this.isModifiable()));
            }
            case "MinimumEngineVersion": {
                return Optional.ofNullable(clazz.cast(this.minimumEngineVersion()));
            }
            case "ChangeType": {
                return Optional.ofNullable(clazz.cast(this.changeTypeAsString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String parameterName;
        private String parameterValue;
        private String description;
        private String source;
        private String dataType;
        private String allowedValues;
        private Boolean isModifiable;
        private String minimumEngineVersion;
        private String changeType;

        private BuilderImpl() {
        }

        private BuilderImpl(Parameter model) {
            this.parameterName(model.parameterName);
            this.parameterValue(model.parameterValue);
            this.description(model.description);
            this.source(model.source);
            this.dataType(model.dataType);
            this.allowedValues(model.allowedValues);
            this.isModifiable(model.isModifiable);
            this.minimumEngineVersion(model.minimumEngineVersion);
            this.changeType(model.changeType);
        }

        public final String getParameterName() {
            return this.parameterName;
        }

        @Override
        public final Builder parameterName(String parameterName) {
            this.parameterName = parameterName;
            return this;
        }

        public final void setParameterName(String parameterName) {
            this.parameterName = parameterName;
        }

        public final String getParameterValue() {
            return this.parameterValue;
        }

        @Override
        public final Builder parameterValue(String parameterValue) {
            this.parameterValue = parameterValue;
            return this;
        }

        public final void setParameterValue(String parameterValue) {
            this.parameterValue = parameterValue;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getSource() {
            return this.source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        public final String getDataType() {
            return this.dataType;
        }

        @Override
        public final Builder dataType(String dataType) {
            this.dataType = dataType;
            return this;
        }

        public final void setDataType(String dataType) {
            this.dataType = dataType;
        }

        public final String getAllowedValues() {
            return this.allowedValues;
        }

        @Override
        public final Builder allowedValues(String allowedValues) {
            this.allowedValues = allowedValues;
            return this;
        }

        public final void setAllowedValues(String allowedValues) {
            this.allowedValues = allowedValues;
        }

        public final Boolean getIsModifiable() {
            return this.isModifiable;
        }

        @Override
        public final Builder isModifiable(Boolean isModifiable) {
            this.isModifiable = isModifiable;
            return this;
        }

        public final void setIsModifiable(Boolean isModifiable) {
            this.isModifiable = isModifiable;
        }

        public final String getMinimumEngineVersion() {
            return this.minimumEngineVersion;
        }

        @Override
        public final Builder minimumEngineVersion(String minimumEngineVersion) {
            this.minimumEngineVersion = minimumEngineVersion;
            return this;
        }

        public final void setMinimumEngineVersion(String minimumEngineVersion) {
            this.minimumEngineVersion = minimumEngineVersion;
        }

        public final String getChangeType() {
            return this.changeType;
        }

        @Override
        public final Builder changeType(String changeType) {
            this.changeType = changeType;
            return this;
        }

        @Override
        public final Builder changeType(ChangeType changeType) {
            this.changeType(changeType.toString());
            return this;
        }

        public final void setChangeType(String changeType) {
            this.changeType = changeType;
        }

        public Parameter build() {
            return new Parameter(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Parameter> {
        public Builder parameterName(String var1);

        public Builder parameterValue(String var1);

        public Builder description(String var1);

        public Builder source(String var1);

        public Builder dataType(String var1);

        public Builder allowedValues(String var1);

        public Builder isModifiable(Boolean var1);

        public Builder minimumEngineVersion(String var1);

        public Builder changeType(String var1);

        public Builder changeType(ChangeType var1);
    }
}

