/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.elasticache.model.ConfigureShard;
import software.amazon.awssdk.services.elasticache.model.ElastiCacheRequest;
import software.amazon.awssdk.services.elasticache.model.ReplicaConfigurationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IncreaseReplicaCountRequest
extends ElastiCacheRequest
implements ToCopyableBuilder<Builder, IncreaseReplicaCountRequest> {
    private final String replicationGroupId;
    private final Integer newReplicaCount;
    private final List<ConfigureShard> replicaConfiguration;
    private final Boolean applyImmediately;

    private IncreaseReplicaCountRequest(BuilderImpl builder) {
        super(builder);
        this.replicationGroupId = builder.replicationGroupId;
        this.newReplicaCount = builder.newReplicaCount;
        this.replicaConfiguration = builder.replicaConfiguration;
        this.applyImmediately = builder.applyImmediately;
    }

    public String replicationGroupId() {
        return this.replicationGroupId;
    }

    public Integer newReplicaCount() {
        return this.newReplicaCount;
    }

    public List<ConfigureShard> replicaConfiguration() {
        return this.replicaConfiguration;
    }

    public Boolean applyImmediately() {
        return this.applyImmediately;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.newReplicaCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicaConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.applyImmediately());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IncreaseReplicaCountRequest)) {
            return false;
        }
        IncreaseReplicaCountRequest other = (IncreaseReplicaCountRequest)((Object)obj);
        return Objects.equals(this.replicationGroupId(), other.replicationGroupId()) && Objects.equals(this.newReplicaCount(), other.newReplicaCount()) && Objects.equals(this.replicaConfiguration(), other.replicaConfiguration()) && Objects.equals(this.applyImmediately(), other.applyImmediately());
    }

    public String toString() {
        return ToString.builder((String)"IncreaseReplicaCountRequest").add("ReplicationGroupId", (Object)this.replicationGroupId()).add("NewReplicaCount", (Object)this.newReplicaCount()).add("ReplicaConfiguration", this.replicaConfiguration()).add("ApplyImmediately", (Object)this.applyImmediately()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReplicationGroupId": {
                return Optional.ofNullable(clazz.cast(this.replicationGroupId()));
            }
            case "NewReplicaCount": {
                return Optional.ofNullable(clazz.cast(this.newReplicaCount()));
            }
            case "ReplicaConfiguration": {
                return Optional.ofNullable(clazz.cast(this.replicaConfiguration()));
            }
            case "ApplyImmediately": {
                return Optional.ofNullable(clazz.cast(this.applyImmediately()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ElastiCacheRequest.BuilderImpl
    implements Builder {
        private String replicationGroupId;
        private Integer newReplicaCount;
        private List<ConfigureShard> replicaConfiguration = DefaultSdkAutoConstructList.getInstance();
        private Boolean applyImmediately;

        private BuilderImpl() {
        }

        private BuilderImpl(IncreaseReplicaCountRequest model) {
            super(model);
            this.replicationGroupId(model.replicationGroupId);
            this.newReplicaCount(model.newReplicaCount);
            this.replicaConfiguration(model.replicaConfiguration);
            this.applyImmediately(model.applyImmediately);
        }

        public final String getReplicationGroupId() {
            return this.replicationGroupId;
        }

        @Override
        public final Builder replicationGroupId(String replicationGroupId) {
            this.replicationGroupId = replicationGroupId;
            return this;
        }

        public final void setReplicationGroupId(String replicationGroupId) {
            this.replicationGroupId = replicationGroupId;
        }

        public final Integer getNewReplicaCount() {
            return this.newReplicaCount;
        }

        @Override
        public final Builder newReplicaCount(Integer newReplicaCount) {
            this.newReplicaCount = newReplicaCount;
            return this;
        }

        public final void setNewReplicaCount(Integer newReplicaCount) {
            this.newReplicaCount = newReplicaCount;
        }

        public final Collection<ConfigureShard.Builder> getReplicaConfiguration() {
            return this.replicaConfiguration != null ? (Collection)this.replicaConfiguration.stream().map(ConfigureShard::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder replicaConfiguration(Collection<ConfigureShard> replicaConfiguration) {
            this.replicaConfiguration = ReplicaConfigurationListCopier.copy(replicaConfiguration);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicaConfiguration(ConfigureShard ... replicaConfiguration) {
            this.replicaConfiguration(Arrays.asList(replicaConfiguration));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicaConfiguration(Consumer<ConfigureShard.Builder> ... replicaConfiguration) {
            this.replicaConfiguration(Stream.of(replicaConfiguration).map(c -> (ConfigureShard)((ConfigureShard.Builder)ConfigureShard.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setReplicaConfiguration(Collection<ConfigureShard.BuilderImpl> replicaConfiguration) {
            this.replicaConfiguration = ReplicaConfigurationListCopier.copyFromBuilder(replicaConfiguration);
        }

        public final Boolean getApplyImmediately() {
            return this.applyImmediately;
        }

        @Override
        public final Builder applyImmediately(Boolean applyImmediately) {
            this.applyImmediately = applyImmediately;
            return this;
        }

        public final void setApplyImmediately(Boolean applyImmediately) {
            this.applyImmediately = applyImmediately;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public IncreaseReplicaCountRequest build() {
            return new IncreaseReplicaCountRequest(this);
        }
    }

    public static interface Builder
    extends ElastiCacheRequest.Builder,
    CopyableBuilder<Builder, IncreaseReplicaCountRequest> {
        public Builder replicationGroupId(String var1);

        public Builder newReplicaCount(Integer var1);

        public Builder replicaConfiguration(Collection<ConfigureShard> var1);

        public Builder replicaConfiguration(ConfigureShard ... var1);

        public Builder replicaConfiguration(Consumer<ConfigureShard.Builder> ... var1);

        public Builder applyImmediately(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

