/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.elasticache.model.ElastiCacheRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteCacheClusterRequest
extends ElastiCacheRequest
implements ToCopyableBuilder<Builder, DeleteCacheClusterRequest> {
    private final String cacheClusterId;
    private final String finalSnapshotIdentifier;

    private DeleteCacheClusterRequest(BuilderImpl builder) {
        super(builder);
        this.cacheClusterId = builder.cacheClusterId;
        this.finalSnapshotIdentifier = builder.finalSnapshotIdentifier;
    }

    public String cacheClusterId() {
        return this.cacheClusterId;
    }

    public String finalSnapshotIdentifier() {
        return this.finalSnapshotIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheClusterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.finalSnapshotIdentifier());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteCacheClusterRequest)) {
            return false;
        }
        DeleteCacheClusterRequest other = (DeleteCacheClusterRequest)((Object)obj);
        return Objects.equals(this.cacheClusterId(), other.cacheClusterId()) && Objects.equals(this.finalSnapshotIdentifier(), other.finalSnapshotIdentifier());
    }

    public String toString() {
        return ToString.builder((String)"DeleteCacheClusterRequest").add("CacheClusterId", (Object)this.cacheClusterId()).add("FinalSnapshotIdentifier", (Object)this.finalSnapshotIdentifier()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CacheClusterId": {
                return Optional.ofNullable(clazz.cast(this.cacheClusterId()));
            }
            case "FinalSnapshotIdentifier": {
                return Optional.ofNullable(clazz.cast(this.finalSnapshotIdentifier()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ElastiCacheRequest.BuilderImpl
    implements Builder {
        private String cacheClusterId;
        private String finalSnapshotIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteCacheClusterRequest model) {
            super(model);
            this.cacheClusterId(model.cacheClusterId);
            this.finalSnapshotIdentifier(model.finalSnapshotIdentifier);
        }

        public final String getCacheClusterId() {
            return this.cacheClusterId;
        }

        @Override
        public final Builder cacheClusterId(String cacheClusterId) {
            this.cacheClusterId = cacheClusterId;
            return this;
        }

        public final void setCacheClusterId(String cacheClusterId) {
            this.cacheClusterId = cacheClusterId;
        }

        public final String getFinalSnapshotIdentifier() {
            return this.finalSnapshotIdentifier;
        }

        @Override
        public final Builder finalSnapshotIdentifier(String finalSnapshotIdentifier) {
            this.finalSnapshotIdentifier = finalSnapshotIdentifier;
            return this;
        }

        public final void setFinalSnapshotIdentifier(String finalSnapshotIdentifier) {
            this.finalSnapshotIdentifier = finalSnapshotIdentifier;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteCacheClusterRequest build() {
            return new DeleteCacheClusterRequest(this);
        }
    }

    public static interface Builder
    extends ElastiCacheRequest.Builder,
    CopyableBuilder<Builder, DeleteCacheClusterRequest> {
        public Builder cacheClusterId(String var1);

        public Builder finalSnapshotIdentifier(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

