/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CacheEngineVersion
implements ToCopyableBuilder<Builder, CacheEngineVersion> {
    private final String engine;
    private final String engineVersion;
    private final String cacheParameterGroupFamily;
    private final String cacheEngineDescription;
    private final String cacheEngineVersionDescription;

    private CacheEngineVersion(BuilderImpl builder) {
        this.engine = builder.engine;
        this.engineVersion = builder.engineVersion;
        this.cacheParameterGroupFamily = builder.cacheParameterGroupFamily;
        this.cacheEngineDescription = builder.cacheEngineDescription;
        this.cacheEngineVersionDescription = builder.cacheEngineVersionDescription;
    }

    public String engine() {
        return this.engine;
    }

    public String engineVersion() {
        return this.engineVersion;
    }

    public String cacheParameterGroupFamily() {
        return this.cacheParameterGroupFamily;
    }

    public String cacheEngineDescription() {
        return this.cacheEngineDescription;
    }

    public String cacheEngineVersionDescription() {
        return this.cacheEngineVersionDescription;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.engine());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheParameterGroupFamily());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheEngineDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheEngineVersionDescription());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CacheEngineVersion)) {
            return false;
        }
        CacheEngineVersion other = (CacheEngineVersion)obj;
        return Objects.equals(this.engine(), other.engine()) && Objects.equals(this.engineVersion(), other.engineVersion()) && Objects.equals(this.cacheParameterGroupFamily(), other.cacheParameterGroupFamily()) && Objects.equals(this.cacheEngineDescription(), other.cacheEngineDescription()) && Objects.equals(this.cacheEngineVersionDescription(), other.cacheEngineVersionDescription());
    }

    public String toString() {
        return ToString.builder((String)"CacheEngineVersion").add("Engine", (Object)this.engine()).add("EngineVersion", (Object)this.engineVersion()).add("CacheParameterGroupFamily", (Object)this.cacheParameterGroupFamily()).add("CacheEngineDescription", (Object)this.cacheEngineDescription()).add("CacheEngineVersionDescription", (Object)this.cacheEngineVersionDescription()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Engine": {
                return Optional.ofNullable(clazz.cast(this.engine()));
            }
            case "EngineVersion": {
                return Optional.ofNullable(clazz.cast(this.engineVersion()));
            }
            case "CacheParameterGroupFamily": {
                return Optional.ofNullable(clazz.cast(this.cacheParameterGroupFamily()));
            }
            case "CacheEngineDescription": {
                return Optional.ofNullable(clazz.cast(this.cacheEngineDescription()));
            }
            case "CacheEngineVersionDescription": {
                return Optional.ofNullable(clazz.cast(this.cacheEngineVersionDescription()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String engine;
        private String engineVersion;
        private String cacheParameterGroupFamily;
        private String cacheEngineDescription;
        private String cacheEngineVersionDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(CacheEngineVersion model) {
            this.engine(model.engine);
            this.engineVersion(model.engineVersion);
            this.cacheParameterGroupFamily(model.cacheParameterGroupFamily);
            this.cacheEngineDescription(model.cacheEngineDescription);
            this.cacheEngineVersionDescription(model.cacheEngineVersionDescription);
        }

        public final String getEngine() {
            return this.engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        public final String getEngineVersion() {
            return this.engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        public final String getCacheParameterGroupFamily() {
            return this.cacheParameterGroupFamily;
        }

        @Override
        public final Builder cacheParameterGroupFamily(String cacheParameterGroupFamily) {
            this.cacheParameterGroupFamily = cacheParameterGroupFamily;
            return this;
        }

        public final void setCacheParameterGroupFamily(String cacheParameterGroupFamily) {
            this.cacheParameterGroupFamily = cacheParameterGroupFamily;
        }

        public final String getCacheEngineDescription() {
            return this.cacheEngineDescription;
        }

        @Override
        public final Builder cacheEngineDescription(String cacheEngineDescription) {
            this.cacheEngineDescription = cacheEngineDescription;
            return this;
        }

        public final void setCacheEngineDescription(String cacheEngineDescription) {
            this.cacheEngineDescription = cacheEngineDescription;
        }

        public final String getCacheEngineVersionDescription() {
            return this.cacheEngineVersionDescription;
        }

        @Override
        public final Builder cacheEngineVersionDescription(String cacheEngineVersionDescription) {
            this.cacheEngineVersionDescription = cacheEngineVersionDescription;
            return this;
        }

        public final void setCacheEngineVersionDescription(String cacheEngineVersionDescription) {
            this.cacheEngineVersionDescription = cacheEngineVersionDescription;
        }

        public CacheEngineVersion build() {
            return new CacheEngineVersion(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CacheEngineVersion> {
        public Builder engine(String var1);

        public Builder engineVersion(String var1);

        public Builder cacheParameterGroupFamily(String var1);

        public Builder cacheEngineDescription(String var1);

        public Builder cacheEngineVersionDescription(String var1);
    }
}

