/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.elasticache.model.ReshardingConfiguration;

public class ReshardingConfigurationUnmarshaller
implements Unmarshaller<ReshardingConfiguration, StaxUnmarshallerContext> {
    private static final ReshardingConfigurationUnmarshaller INSTANCE = new ReshardingConfigurationUnmarshaller();

    public ReshardingConfiguration unmarshall(StaxUnmarshallerContext context) throws Exception {
        ReshardingConfiguration.Builder reshardingConfiguration;
        block5: {
            reshardingConfiguration = ReshardingConfiguration.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<String> preferredAvailabilityZones = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    reshardingConfiguration.preferredAvailabilityZones(preferredAvailabilityZones);
                    break block5;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("PreferredAvailabilityZones", targetDepth)) {
                        preferredAvailabilityZones = new ArrayList<String>();
                        continue;
                    }
                    if (!context.testExpression("PreferredAvailabilityZones/AvailabilityZone", targetDepth)) continue;
                    preferredAvailabilityZones.add(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            reshardingConfiguration.preferredAvailabilityZones(preferredAvailabilityZones);
        }
        return (ReshardingConfiguration)reshardingConfiguration.build();
    }

    public static ReshardingConfigurationUnmarshaller getInstance() {
        return INSTANCE;
    }
}

