/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.elasticache.model.ModifyCacheSubnetGroupRequest;

public class ModifyCacheSubnetGroupRequestMarshaller
implements Marshaller<Request<ModifyCacheSubnetGroupRequest>, ModifyCacheSubnetGroupRequest> {
    public Request<ModifyCacheSubnetGroupRequest> marshall(ModifyCacheSubnetGroupRequest modifyCacheSubnetGroupRequest) {
        if (modifyCacheSubnetGroupRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)modifyCacheSubnetGroupRequest, "ElastiCacheClient");
        request.addParameter("Action", "ModifyCacheSubnetGroup");
        request.addParameter("Version", "2015-02-02");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyCacheSubnetGroupRequest.cacheSubnetGroupName() != null) {
            request.addParameter("CacheSubnetGroupName", StringConversion.fromString((String)modifyCacheSubnetGroupRequest.cacheSubnetGroupName()));
        }
        if (modifyCacheSubnetGroupRequest.cacheSubnetGroupDescription() != null) {
            request.addParameter("CacheSubnetGroupDescription", StringConversion.fromString((String)modifyCacheSubnetGroupRequest.cacheSubnetGroupDescription()));
        }
        if (modifyCacheSubnetGroupRequest.subnetIds().isEmpty() && !(modifyCacheSubnetGroupRequest.subnetIds() instanceof SdkAutoConstructList)) {
            request.addParameter("SubnetIds", "");
        } else if (!modifyCacheSubnetGroupRequest.subnetIds().isEmpty() && !(modifyCacheSubnetGroupRequest.subnetIds() instanceof SdkAutoConstructList)) {
            List<String> subnetIdsList = modifyCacheSubnetGroupRequest.subnetIds();
            int subnetIdsListIndex = 1;
            for (String subnetIdsListValue : subnetIdsList) {
                if (subnetIdsListValue != null) {
                    request.addParameter("SubnetIds.SubnetIdentifier." + subnetIdsListIndex, StringConversion.fromString((String)subnetIdsListValue));
                }
                ++subnetIdsListIndex;
            }
        }
        return request;
    }
}

