/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.elasticache.model.DescribeSnapshotsRequest;

public class DescribeSnapshotsRequestMarshaller
implements Marshaller<Request<DescribeSnapshotsRequest>, DescribeSnapshotsRequest> {
    public Request<DescribeSnapshotsRequest> marshall(DescribeSnapshotsRequest describeSnapshotsRequest) {
        if (describeSnapshotsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeSnapshotsRequest, "ElastiCacheClient");
        request.addParameter("Action", "DescribeSnapshots");
        request.addParameter("Version", "2015-02-02");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeSnapshotsRequest.replicationGroupId() != null) {
            request.addParameter("ReplicationGroupId", StringConversion.fromString((String)describeSnapshotsRequest.replicationGroupId()));
        }
        if (describeSnapshotsRequest.cacheClusterId() != null) {
            request.addParameter("CacheClusterId", StringConversion.fromString((String)describeSnapshotsRequest.cacheClusterId()));
        }
        if (describeSnapshotsRequest.snapshotName() != null) {
            request.addParameter("SnapshotName", StringConversion.fromString((String)describeSnapshotsRequest.snapshotName()));
        }
        if (describeSnapshotsRequest.snapshotSource() != null) {
            request.addParameter("SnapshotSource", StringConversion.fromString((String)describeSnapshotsRequest.snapshotSource()));
        }
        if (describeSnapshotsRequest.marker() != null) {
            request.addParameter("Marker", StringConversion.fromString((String)describeSnapshotsRequest.marker()));
        }
        if (describeSnapshotsRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringConversion.fromInteger((Integer)describeSnapshotsRequest.maxRecords()));
        }
        if (describeSnapshotsRequest.showNodeGroupConfig() != null) {
            request.addParameter("ShowNodeGroupConfig", StringConversion.fromBoolean((Boolean)describeSnapshotsRequest.showNodeGroupConfig()));
        }
        return request;
    }
}

