/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.elasticache.model.DescribeCacheEngineVersionsRequest;

public class DescribeCacheEngineVersionsRequestMarshaller
implements Marshaller<Request<DescribeCacheEngineVersionsRequest>, DescribeCacheEngineVersionsRequest> {
    public Request<DescribeCacheEngineVersionsRequest> marshall(DescribeCacheEngineVersionsRequest describeCacheEngineVersionsRequest) {
        if (describeCacheEngineVersionsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeCacheEngineVersionsRequest, "ElastiCacheClient");
        request.addParameter("Action", "DescribeCacheEngineVersions");
        request.addParameter("Version", "2015-02-02");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeCacheEngineVersionsRequest.engine() != null) {
            request.addParameter("Engine", StringConversion.fromString((String)describeCacheEngineVersionsRequest.engine()));
        }
        if (describeCacheEngineVersionsRequest.engineVersion() != null) {
            request.addParameter("EngineVersion", StringConversion.fromString((String)describeCacheEngineVersionsRequest.engineVersion()));
        }
        if (describeCacheEngineVersionsRequest.cacheParameterGroupFamily() != null) {
            request.addParameter("CacheParameterGroupFamily", StringConversion.fromString((String)describeCacheEngineVersionsRequest.cacheParameterGroupFamily()));
        }
        if (describeCacheEngineVersionsRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringConversion.fromInteger((Integer)describeCacheEngineVersionsRequest.maxRecords()));
        }
        if (describeCacheEngineVersionsRequest.marker() != null) {
            request.addParameter("Marker", StringConversion.fromString((String)describeCacheEngineVersionsRequest.marker()));
        }
        if (describeCacheEngineVersionsRequest.defaultOnly() != null) {
            request.addParameter("DefaultOnly", StringConversion.fromBoolean((Boolean)describeCacheEngineVersionsRequest.defaultOnly()));
        }
        return request;
    }
}

