/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.elasticache.model.DeleteCacheSecurityGroupRequest;

public class DeleteCacheSecurityGroupRequestMarshaller
implements Marshaller<Request<DeleteCacheSecurityGroupRequest>, DeleteCacheSecurityGroupRequest> {
    public Request<DeleteCacheSecurityGroupRequest> marshall(DeleteCacheSecurityGroupRequest deleteCacheSecurityGroupRequest) {
        if (deleteCacheSecurityGroupRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)deleteCacheSecurityGroupRequest, "ElastiCacheClient");
        request.addParameter("Action", "DeleteCacheSecurityGroup");
        request.addParameter("Version", "2015-02-02");
        request.setHttpMethod(HttpMethodName.POST);
        if (deleteCacheSecurityGroupRequest.cacheSecurityGroupName() != null) {
            request.addParameter("CacheSecurityGroupName", StringConversion.fromString((String)deleteCacheSecurityGroupRequest.cacheSecurityGroupName()));
        }
        return request;
    }
}

