/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.elasticache.model.CreateCacheClusterRequest;
import software.amazon.awssdk.services.elasticache.model.Tag;

public class CreateCacheClusterRequestMarshaller
implements Marshaller<Request<CreateCacheClusterRequest>, CreateCacheClusterRequest> {
    public Request<CreateCacheClusterRequest> marshall(CreateCacheClusterRequest createCacheClusterRequest) {
        if (createCacheClusterRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)createCacheClusterRequest, "ElastiCacheClient");
        request.addParameter("Action", "CreateCacheCluster");
        request.addParameter("Version", "2015-02-02");
        request.setHttpMethod(HttpMethodName.POST);
        if (createCacheClusterRequest.cacheClusterId() != null) {
            request.addParameter("CacheClusterId", StringConversion.fromString((String)createCacheClusterRequest.cacheClusterId()));
        }
        if (createCacheClusterRequest.replicationGroupId() != null) {
            request.addParameter("ReplicationGroupId", StringConversion.fromString((String)createCacheClusterRequest.replicationGroupId()));
        }
        if (createCacheClusterRequest.azModeAsString() != null) {
            request.addParameter("AZMode", StringConversion.fromString((String)createCacheClusterRequest.azModeAsString()));
        }
        if (createCacheClusterRequest.preferredAvailabilityZone() != null) {
            request.addParameter("PreferredAvailabilityZone", StringConversion.fromString((String)createCacheClusterRequest.preferredAvailabilityZone()));
        }
        if (createCacheClusterRequest.preferredAvailabilityZones().isEmpty() && !(createCacheClusterRequest.preferredAvailabilityZones() instanceof SdkAutoConstructList)) {
            request.addParameter("PreferredAvailabilityZones", "");
        } else if (!createCacheClusterRequest.preferredAvailabilityZones().isEmpty() && !(createCacheClusterRequest.preferredAvailabilityZones() instanceof SdkAutoConstructList)) {
            List<String> preferredAvailabilityZonesList = createCacheClusterRequest.preferredAvailabilityZones();
            int preferredAvailabilityZonesListIndex = 1;
            for (String preferredAvailabilityZonesListValue : preferredAvailabilityZonesList) {
                if (preferredAvailabilityZonesListValue != null) {
                    request.addParameter("PreferredAvailabilityZones.PreferredAvailabilityZone." + preferredAvailabilityZonesListIndex, StringConversion.fromString((String)preferredAvailabilityZonesListValue));
                }
                ++preferredAvailabilityZonesListIndex;
            }
        }
        if (createCacheClusterRequest.numCacheNodes() != null) {
            request.addParameter("NumCacheNodes", StringConversion.fromInteger((Integer)createCacheClusterRequest.numCacheNodes()));
        }
        if (createCacheClusterRequest.cacheNodeType() != null) {
            request.addParameter("CacheNodeType", StringConversion.fromString((String)createCacheClusterRequest.cacheNodeType()));
        }
        if (createCacheClusterRequest.engine() != null) {
            request.addParameter("Engine", StringConversion.fromString((String)createCacheClusterRequest.engine()));
        }
        if (createCacheClusterRequest.engineVersion() != null) {
            request.addParameter("EngineVersion", StringConversion.fromString((String)createCacheClusterRequest.engineVersion()));
        }
        if (createCacheClusterRequest.cacheParameterGroupName() != null) {
            request.addParameter("CacheParameterGroupName", StringConversion.fromString((String)createCacheClusterRequest.cacheParameterGroupName()));
        }
        if (createCacheClusterRequest.cacheSubnetGroupName() != null) {
            request.addParameter("CacheSubnetGroupName", StringConversion.fromString((String)createCacheClusterRequest.cacheSubnetGroupName()));
        }
        if (createCacheClusterRequest.cacheSecurityGroupNames().isEmpty() && !(createCacheClusterRequest.cacheSecurityGroupNames() instanceof SdkAutoConstructList)) {
            request.addParameter("CacheSecurityGroupNames", "");
        } else if (!createCacheClusterRequest.cacheSecurityGroupNames().isEmpty() && !(createCacheClusterRequest.cacheSecurityGroupNames() instanceof SdkAutoConstructList)) {
            List<String> cacheSecurityGroupNamesList = createCacheClusterRequest.cacheSecurityGroupNames();
            int cacheSecurityGroupNamesListIndex = 1;
            for (String cacheSecurityGroupNamesListValue : cacheSecurityGroupNamesList) {
                if (cacheSecurityGroupNamesListValue != null) {
                    request.addParameter("CacheSecurityGroupNames.CacheSecurityGroupName." + cacheSecurityGroupNamesListIndex, StringConversion.fromString((String)cacheSecurityGroupNamesListValue));
                }
                ++cacheSecurityGroupNamesListIndex;
            }
        }
        if (createCacheClusterRequest.securityGroupIds().isEmpty() && !(createCacheClusterRequest.securityGroupIds() instanceof SdkAutoConstructList)) {
            request.addParameter("SecurityGroupIds", "");
        } else if (!createCacheClusterRequest.securityGroupIds().isEmpty() && !(createCacheClusterRequest.securityGroupIds() instanceof SdkAutoConstructList)) {
            List<String> securityGroupIdsList = createCacheClusterRequest.securityGroupIds();
            int securityGroupIdsListIndex = 1;
            for (String securityGroupIdsListValue : securityGroupIdsList) {
                if (securityGroupIdsListValue != null) {
                    request.addParameter("SecurityGroupIds.SecurityGroupId." + securityGroupIdsListIndex, StringConversion.fromString((String)securityGroupIdsListValue));
                }
                ++securityGroupIdsListIndex;
            }
        }
        if (createCacheClusterRequest.tags().isEmpty() && !(createCacheClusterRequest.tags() instanceof SdkAutoConstructList)) {
            request.addParameter("Tags", "");
        } else if (!createCacheClusterRequest.tags().isEmpty() && !(createCacheClusterRequest.tags() instanceof SdkAutoConstructList)) {
            List<Tag> tagsList = createCacheClusterRequest.tags();
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue.key() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Key", StringConversion.fromString((String)tagsListValue.key()));
                }
                if (tagsListValue.value() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Value", StringConversion.fromString((String)tagsListValue.value()));
                }
                ++tagsListIndex;
            }
        }
        if (createCacheClusterRequest.snapshotArns().isEmpty() && !(createCacheClusterRequest.snapshotArns() instanceof SdkAutoConstructList)) {
            request.addParameter("SnapshotArns", "");
        } else if (!createCacheClusterRequest.snapshotArns().isEmpty() && !(createCacheClusterRequest.snapshotArns() instanceof SdkAutoConstructList)) {
            List<String> snapshotArnsList = createCacheClusterRequest.snapshotArns();
            int snapshotArnsListIndex = 1;
            for (String snapshotArnsListValue : snapshotArnsList) {
                if (snapshotArnsListValue != null) {
                    request.addParameter("SnapshotArns.SnapshotArn." + snapshotArnsListIndex, StringConversion.fromString((String)snapshotArnsListValue));
                }
                ++snapshotArnsListIndex;
            }
        }
        if (createCacheClusterRequest.snapshotName() != null) {
            request.addParameter("SnapshotName", StringConversion.fromString((String)createCacheClusterRequest.snapshotName()));
        }
        if (createCacheClusterRequest.preferredMaintenanceWindow() != null) {
            request.addParameter("PreferredMaintenanceWindow", StringConversion.fromString((String)createCacheClusterRequest.preferredMaintenanceWindow()));
        }
        if (createCacheClusterRequest.port() != null) {
            request.addParameter("Port", StringConversion.fromInteger((Integer)createCacheClusterRequest.port()));
        }
        if (createCacheClusterRequest.notificationTopicArn() != null) {
            request.addParameter("NotificationTopicArn", StringConversion.fromString((String)createCacheClusterRequest.notificationTopicArn()));
        }
        if (createCacheClusterRequest.autoMinorVersionUpgrade() != null) {
            request.addParameter("AutoMinorVersionUpgrade", StringConversion.fromBoolean((Boolean)createCacheClusterRequest.autoMinorVersionUpgrade()));
        }
        if (createCacheClusterRequest.snapshotRetentionLimit() != null) {
            request.addParameter("SnapshotRetentionLimit", StringConversion.fromInteger((Integer)createCacheClusterRequest.snapshotRetentionLimit()));
        }
        if (createCacheClusterRequest.snapshotWindow() != null) {
            request.addParameter("SnapshotWindow", StringConversion.fromString((String)createCacheClusterRequest.snapshotWindow()));
        }
        if (createCacheClusterRequest.authToken() != null) {
            request.addParameter("AuthToken", StringConversion.fromString((String)createCacheClusterRequest.authToken()));
        }
        return request;
    }
}

