/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.elasticache.ElastiCacheAsyncClient;
import software.amazon.awssdk.services.elasticache.model.CacheEngineVersion;
import software.amazon.awssdk.services.elasticache.model.DescribeCacheEngineVersionsRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeCacheEngineVersionsResponse;

public class DescribeCacheEngineVersionsPublisher
implements SdkPublisher<DescribeCacheEngineVersionsResponse> {
    private final ElastiCacheAsyncClient client;
    private final DescribeCacheEngineVersionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeCacheEngineVersionsPublisher(ElastiCacheAsyncClient client, DescribeCacheEngineVersionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeCacheEngineVersionsPublisher(ElastiCacheAsyncClient client, DescribeCacheEngineVersionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeCacheEngineVersionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeCacheEngineVersionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<CacheEngineVersion> cacheEngineVersions() {
        Function<DescribeCacheEngineVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.cacheEngineVersions() != null) {
                return response.cacheEngineVersions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeCacheEngineVersionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private final DescribeCacheEngineVersionsPublisher resume(DescribeCacheEngineVersionsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeCacheEngineVersionsPublisher(this.client, (DescribeCacheEngineVersionsRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new DescribeCacheEngineVersionsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super DescribeCacheEngineVersionsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class DescribeCacheEngineVersionsResponseFetcher
    implements AsyncPageFetcher<DescribeCacheEngineVersionsResponse> {
        private DescribeCacheEngineVersionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeCacheEngineVersionsResponse previousPage) {
            return previousPage.marker() != null && !SdkAutoConstructList.class.isInstance(previousPage.marker()) && !SdkAutoConstructMap.class.isInstance(previousPage.marker());
        }

        public CompletableFuture<DescribeCacheEngineVersionsResponse> nextPage(DescribeCacheEngineVersionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeCacheEngineVersionsPublisher.this.client.describeCacheEngineVersions(DescribeCacheEngineVersionsPublisher.this.firstRequest);
            }
            return DescribeCacheEngineVersionsPublisher.this.client.describeCacheEngineVersions((DescribeCacheEngineVersionsRequest)((Object)DescribeCacheEngineVersionsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

