/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.elasticache.model.ElastiCacheRequest;
import software.amazon.awssdk.services.elasticache.model.SubnetIdentifierListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyCacheSubnetGroupRequest
extends ElastiCacheRequest
implements ToCopyableBuilder<Builder, ModifyCacheSubnetGroupRequest> {
    private final String cacheSubnetGroupName;
    private final String cacheSubnetGroupDescription;
    private final List<String> subnetIds;

    private ModifyCacheSubnetGroupRequest(BuilderImpl builder) {
        super(builder);
        this.cacheSubnetGroupName = builder.cacheSubnetGroupName;
        this.cacheSubnetGroupDescription = builder.cacheSubnetGroupDescription;
        this.subnetIds = builder.subnetIds;
    }

    public String cacheSubnetGroupName() {
        return this.cacheSubnetGroupName;
    }

    public String cacheSubnetGroupDescription() {
        return this.cacheSubnetGroupDescription;
    }

    public List<String> subnetIds() {
        return this.subnetIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheSubnetGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheSubnetGroupDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetIds());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyCacheSubnetGroupRequest)) {
            return false;
        }
        ModifyCacheSubnetGroupRequest other = (ModifyCacheSubnetGroupRequest)((Object)obj);
        return Objects.equals(this.cacheSubnetGroupName(), other.cacheSubnetGroupName()) && Objects.equals(this.cacheSubnetGroupDescription(), other.cacheSubnetGroupDescription()) && Objects.equals(this.subnetIds(), other.subnetIds());
    }

    public String toString() {
        return ToString.builder((String)"ModifyCacheSubnetGroupRequest").add("CacheSubnetGroupName", (Object)this.cacheSubnetGroupName()).add("CacheSubnetGroupDescription", (Object)this.cacheSubnetGroupDescription()).add("SubnetIds", this.subnetIds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CacheSubnetGroupName": {
                return Optional.ofNullable(clazz.cast(this.cacheSubnetGroupName()));
            }
            case "CacheSubnetGroupDescription": {
                return Optional.ofNullable(clazz.cast(this.cacheSubnetGroupDescription()));
            }
            case "SubnetIds": {
                return Optional.ofNullable(clazz.cast(this.subnetIds()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ElastiCacheRequest.BuilderImpl
    implements Builder {
        private String cacheSubnetGroupName;
        private String cacheSubnetGroupDescription;
        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyCacheSubnetGroupRequest model) {
            super(model);
            this.cacheSubnetGroupName(model.cacheSubnetGroupName);
            this.cacheSubnetGroupDescription(model.cacheSubnetGroupDescription);
            this.subnetIds(model.subnetIds);
        }

        public final String getCacheSubnetGroupName() {
            return this.cacheSubnetGroupName;
        }

        @Override
        public final Builder cacheSubnetGroupName(String cacheSubnetGroupName) {
            this.cacheSubnetGroupName = cacheSubnetGroupName;
            return this;
        }

        public final void setCacheSubnetGroupName(String cacheSubnetGroupName) {
            this.cacheSubnetGroupName = cacheSubnetGroupName;
        }

        public final String getCacheSubnetGroupDescription() {
            return this.cacheSubnetGroupDescription;
        }

        @Override
        public final Builder cacheSubnetGroupDescription(String cacheSubnetGroupDescription) {
            this.cacheSubnetGroupDescription = cacheSubnetGroupDescription;
            return this;
        }

        public final void setCacheSubnetGroupDescription(String cacheSubnetGroupDescription) {
            this.cacheSubnetGroupDescription = cacheSubnetGroupDescription;
        }

        public final Collection<String> getSubnetIds() {
            return this.subnetIds;
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdentifierListCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String ... subnetIds) {
            this.subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdentifierListCopier.copy(subnetIds);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyCacheSubnetGroupRequest build() {
            return new ModifyCacheSubnetGroupRequest(this);
        }
    }

    public static interface Builder
    extends ElastiCacheRequest.Builder,
    CopyableBuilder<Builder, ModifyCacheSubnetGroupRequest> {
        public Builder cacheSubnetGroupName(String var1);

        public Builder cacheSubnetGroupDescription(String var1);

        public Builder subnetIds(Collection<String> var1);

        public Builder subnetIds(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

