/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.elasticache.model.CacheSubnetGroup;
import software.amazon.awssdk.services.elasticache.model.CacheSubnetGroupsCopier;
import software.amazon.awssdk.services.elasticache.model.ElastiCacheResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeCacheSubnetGroupsResponse
extends ElastiCacheResponse
implements ToCopyableBuilder<Builder, DescribeCacheSubnetGroupsResponse> {
    private final String marker;
    private final List<CacheSubnetGroup> cacheSubnetGroups;

    private DescribeCacheSubnetGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.cacheSubnetGroups = builder.cacheSubnetGroups;
    }

    public String marker() {
        return this.marker;
    }

    public List<CacheSubnetGroup> cacheSubnetGroups() {
        return this.cacheSubnetGroups;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheSubnetGroups());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCacheSubnetGroupsResponse)) {
            return false;
        }
        DescribeCacheSubnetGroupsResponse other = (DescribeCacheSubnetGroupsResponse)((Object)obj);
        return Objects.equals(this.marker(), other.marker()) && Objects.equals(this.cacheSubnetGroups(), other.cacheSubnetGroups());
    }

    public String toString() {
        return ToString.builder((String)"DescribeCacheSubnetGroupsResponse").add("Marker", (Object)this.marker()).add("CacheSubnetGroups", this.cacheSubnetGroups()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "CacheSubnetGroups": {
                return Optional.ofNullable(clazz.cast(this.cacheSubnetGroups()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ElastiCacheResponse.BuilderImpl
    implements Builder {
        private String marker;
        private List<CacheSubnetGroup> cacheSubnetGroups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCacheSubnetGroupsResponse model) {
            super(model);
            this.marker(model.marker);
            this.cacheSubnetGroups(model.cacheSubnetGroups);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<CacheSubnetGroup.Builder> getCacheSubnetGroups() {
            return this.cacheSubnetGroups != null ? (Collection)this.cacheSubnetGroups.stream().map(CacheSubnetGroup::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder cacheSubnetGroups(Collection<CacheSubnetGroup> cacheSubnetGroups) {
            this.cacheSubnetGroups = CacheSubnetGroupsCopier.copy(cacheSubnetGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cacheSubnetGroups(CacheSubnetGroup ... cacheSubnetGroups) {
            this.cacheSubnetGroups(Arrays.asList(cacheSubnetGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cacheSubnetGroups(Consumer<CacheSubnetGroup.Builder> ... cacheSubnetGroups) {
            this.cacheSubnetGroups(Stream.of(cacheSubnetGroups).map(c -> (CacheSubnetGroup)((CacheSubnetGroup.Builder)CacheSubnetGroup.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCacheSubnetGroups(Collection<CacheSubnetGroup.BuilderImpl> cacheSubnetGroups) {
            this.cacheSubnetGroups = CacheSubnetGroupsCopier.copyFromBuilder(cacheSubnetGroups);
        }

        @Override
        public DescribeCacheSubnetGroupsResponse build() {
            return new DescribeCacheSubnetGroupsResponse(this);
        }
    }

    public static interface Builder
    extends ElastiCacheResponse.Builder,
    CopyableBuilder<Builder, DescribeCacheSubnetGroupsResponse> {
        public Builder marker(String var1);

        public Builder cacheSubnetGroups(Collection<CacheSubnetGroup> var1);

        public Builder cacheSubnetGroups(CacheSubnetGroup ... var1);

        public Builder cacheSubnetGroups(Consumer<CacheSubnetGroup.Builder> ... var1);
    }
}

