/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CacheParameterGroup
implements ToCopyableBuilder<Builder, CacheParameterGroup> {
    private final String cacheParameterGroupName;
    private final String cacheParameterGroupFamily;
    private final String description;

    private CacheParameterGroup(BuilderImpl builder) {
        this.cacheParameterGroupName = builder.cacheParameterGroupName;
        this.cacheParameterGroupFamily = builder.cacheParameterGroupFamily;
        this.description = builder.description;
    }

    public String cacheParameterGroupName() {
        return this.cacheParameterGroupName;
    }

    public String cacheParameterGroupFamily() {
        return this.cacheParameterGroupFamily;
    }

    public String description() {
        return this.description;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheParameterGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheParameterGroupFamily());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CacheParameterGroup)) {
            return false;
        }
        CacheParameterGroup other = (CacheParameterGroup)obj;
        return Objects.equals(this.cacheParameterGroupName(), other.cacheParameterGroupName()) && Objects.equals(this.cacheParameterGroupFamily(), other.cacheParameterGroupFamily()) && Objects.equals(this.description(), other.description());
    }

    public String toString() {
        return ToString.builder((String)"CacheParameterGroup").add("CacheParameterGroupName", (Object)this.cacheParameterGroupName()).add("CacheParameterGroupFamily", (Object)this.cacheParameterGroupFamily()).add("Description", (Object)this.description()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CacheParameterGroupName": {
                return Optional.ofNullable(clazz.cast(this.cacheParameterGroupName()));
            }
            case "CacheParameterGroupFamily": {
                return Optional.ofNullable(clazz.cast(this.cacheParameterGroupFamily()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String cacheParameterGroupName;
        private String cacheParameterGroupFamily;
        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(CacheParameterGroup model) {
            this.cacheParameterGroupName(model.cacheParameterGroupName);
            this.cacheParameterGroupFamily(model.cacheParameterGroupFamily);
            this.description(model.description);
        }

        public final String getCacheParameterGroupName() {
            return this.cacheParameterGroupName;
        }

        @Override
        public final Builder cacheParameterGroupName(String cacheParameterGroupName) {
            this.cacheParameterGroupName = cacheParameterGroupName;
            return this;
        }

        public final void setCacheParameterGroupName(String cacheParameterGroupName) {
            this.cacheParameterGroupName = cacheParameterGroupName;
        }

        public final String getCacheParameterGroupFamily() {
            return this.cacheParameterGroupFamily;
        }

        @Override
        public final Builder cacheParameterGroupFamily(String cacheParameterGroupFamily) {
            this.cacheParameterGroupFamily = cacheParameterGroupFamily;
            return this;
        }

        public final void setCacheParameterGroupFamily(String cacheParameterGroupFamily) {
            this.cacheParameterGroupFamily = cacheParameterGroupFamily;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public CacheParameterGroup build() {
            return new CacheParameterGroup(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CacheParameterGroup> {
        public Builder cacheParameterGroupName(String var1);

        public Builder cacheParameterGroupFamily(String var1);

        public Builder description(String var1);
    }
}

