/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.elasticache.ElastiCacheAsyncClient;
import software.amazon.awssdk.services.elasticache.model.CacheCluster;
import software.amazon.awssdk.services.elasticache.model.DescribeCacheClustersRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeCacheClustersResponse;

public class DescribeCacheClustersPublisher
implements SdkPublisher<DescribeCacheClustersResponse> {
    private final ElastiCacheAsyncClient client;
    private final DescribeCacheClustersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeCacheClustersPublisher(ElastiCacheAsyncClient client, DescribeCacheClustersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeCacheClustersPublisher(ElastiCacheAsyncClient client, DescribeCacheClustersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeCacheClustersResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeCacheClustersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final SdkPublisher<CacheCluster> cacheClusters() {
        Function<DescribeCacheClustersResponse, Iterator> getIterator = response -> {
            if (response != null && response.cacheClusters() != null) {
                return response.cacheClusters().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsPublisher((AsyncPageFetcher)new DescribeCacheClustersResponseFetcher(), getIterator, this.isLastPage);
    }

    public final DescribeCacheClustersPublisher resume(DescribeCacheClustersResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeCacheClustersPublisher(this.client, (DescribeCacheClustersRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new DescribeCacheClustersPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super DescribeCacheClustersResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class DescribeCacheClustersResponseFetcher
    implements AsyncPageFetcher<DescribeCacheClustersResponse> {
        private DescribeCacheClustersResponseFetcher() {
        }

        public boolean hasNextPage(DescribeCacheClustersResponse previousPage) {
            return previousPage.marker() != null;
        }

        public CompletableFuture<DescribeCacheClustersResponse> nextPage(DescribeCacheClustersResponse previousPage) {
            if (previousPage == null) {
                return DescribeCacheClustersPublisher.this.client.describeCacheClusters(DescribeCacheClustersPublisher.this.firstRequest);
            }
            return DescribeCacheClustersPublisher.this.client.describeCacheClusters((DescribeCacheClustersRequest)((Object)DescribeCacheClustersPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

