/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.elasticache.model.ModifyCacheSubnetGroupRequest;
import software.amazon.awssdk.util.StringUtils;

public class ModifyCacheSubnetGroupRequestMarshaller
implements Marshaller<Request<ModifyCacheSubnetGroupRequest>, ModifyCacheSubnetGroupRequest> {
    public Request<ModifyCacheSubnetGroupRequest> marshall(ModifyCacheSubnetGroupRequest modifyCacheSubnetGroupRequest) {
        SdkInternalList subnetIdsList;
        if (modifyCacheSubnetGroupRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)modifyCacheSubnetGroupRequest, "ElastiCacheClient");
        request.addParameter("Action", "ModifyCacheSubnetGroup");
        request.addParameter("Version", "2015-02-02");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyCacheSubnetGroupRequest.cacheSubnetGroupName() != null) {
            request.addParameter("CacheSubnetGroupName", StringUtils.fromString((String)modifyCacheSubnetGroupRequest.cacheSubnetGroupName()));
        }
        if (modifyCacheSubnetGroupRequest.cacheSubnetGroupDescription() != null) {
            request.addParameter("CacheSubnetGroupDescription", StringUtils.fromString((String)modifyCacheSubnetGroupRequest.cacheSubnetGroupDescription()));
        }
        if (!(subnetIdsList = (SdkInternalList)modifyCacheSubnetGroupRequest.subnetIds()).isEmpty() || !subnetIdsList.isAutoConstruct()) {
            int subnetIdsListIndex = 1;
            for (String subnetIdsListValue : subnetIdsList) {
                if (subnetIdsListValue != null) {
                    request.addParameter("SubnetIds.SubnetIdentifier." + subnetIdsListIndex, StringUtils.fromString((String)subnetIdsListValue));
                }
                ++subnetIdsListIndex;
            }
        }
        return request;
    }
}

