/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.elasticache.model.CacheNodeTypeSpecificParameter;
import software.amazon.awssdk.services.elasticache.model.EngineDefaults;
import software.amazon.awssdk.services.elasticache.model.Parameter;
import software.amazon.awssdk.services.elasticache.transform.CacheNodeTypeSpecificParameterUnmarshaller;
import software.amazon.awssdk.services.elasticache.transform.ParameterUnmarshaller;

public class EngineDefaultsUnmarshaller
implements Unmarshaller<EngineDefaults, StaxUnmarshallerContext> {
    private static EngineDefaultsUnmarshaller INSTANCE;

    public EngineDefaults unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        EngineDefaults.Builder engineDefaults = EngineDefaults.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            targetDepth += 3;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("CacheParameterGroupFamily", targetDepth)) {
                    engineDefaults.cacheParameterGroupFamily(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Marker", targetDepth)) {
                    engineDefaults.marker(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Parameters", targetDepth)) {
                    engineDefaults.parameters(new ArrayList<Parameter>());
                    continue;
                }
                if (context.testExpression("Parameters/Parameter", targetDepth)) {
                    engineDefaults.parameters(ParameterUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("CacheNodeTypeSpecificParameters", targetDepth)) {
                    engineDefaults.cacheNodeTypeSpecificParameters(new ArrayList<CacheNodeTypeSpecificParameter>());
                    continue;
                }
                if (!context.testExpression("CacheNodeTypeSpecificParameters/CacheNodeTypeSpecificParameter", targetDepth)) continue;
                engineDefaults.cacheNodeTypeSpecificParameters(CacheNodeTypeSpecificParameterUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (EngineDefaults)engineDefaults.build();
    }

    public static EngineDefaultsUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new EngineDefaultsUnmarshaller();
        }
        return INSTANCE;
    }
}

