/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.elasticache.model.CreateReplicationGroupRequest;
import software.amazon.awssdk.services.elasticache.model.NodeGroupConfiguration;
import software.amazon.awssdk.services.elasticache.model.Tag;
import software.amazon.awssdk.util.StringUtils;

public class CreateReplicationGroupRequestMarshaller
implements Marshaller<Request<CreateReplicationGroupRequest>, CreateReplicationGroupRequest> {
    public Request<CreateReplicationGroupRequest> marshall(CreateReplicationGroupRequest createReplicationGroupRequest) {
        SdkInternalList snapshotArnsList;
        SdkInternalList tagsList;
        SdkInternalList securityGroupIdsList;
        SdkInternalList cacheSecurityGroupNamesList;
        SdkInternalList nodeGroupConfigurationList;
        SdkInternalList preferredCacheClusterAZsList;
        if (createReplicationGroupRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createReplicationGroupRequest, "ElastiCacheClient");
        request.addParameter("Action", "CreateReplicationGroup");
        request.addParameter("Version", "2015-02-02");
        request.setHttpMethod(HttpMethodName.POST);
        if (createReplicationGroupRequest.replicationGroupId() != null) {
            request.addParameter("ReplicationGroupId", StringUtils.fromString((String)createReplicationGroupRequest.replicationGroupId()));
        }
        if (createReplicationGroupRequest.replicationGroupDescription() != null) {
            request.addParameter("ReplicationGroupDescription", StringUtils.fromString((String)createReplicationGroupRequest.replicationGroupDescription()));
        }
        if (createReplicationGroupRequest.primaryClusterId() != null) {
            request.addParameter("PrimaryClusterId", StringUtils.fromString((String)createReplicationGroupRequest.primaryClusterId()));
        }
        if (createReplicationGroupRequest.automaticFailoverEnabled() != null) {
            request.addParameter("AutomaticFailoverEnabled", StringUtils.fromBoolean((Boolean)createReplicationGroupRequest.automaticFailoverEnabled()));
        }
        if (createReplicationGroupRequest.numCacheClusters() != null) {
            request.addParameter("NumCacheClusters", StringUtils.fromInteger((Integer)createReplicationGroupRequest.numCacheClusters()));
        }
        if (!(preferredCacheClusterAZsList = (SdkInternalList)createReplicationGroupRequest.preferredCacheClusterAZs()).isEmpty() || !preferredCacheClusterAZsList.isAutoConstruct()) {
            int preferredCacheClusterAZsListIndex = 1;
            for (Object preferredCacheClusterAZsListValue : preferredCacheClusterAZsList) {
                if (preferredCacheClusterAZsListValue != null) {
                    request.addParameter("PreferredCacheClusterAZs.AvailabilityZone." + preferredCacheClusterAZsListIndex, StringUtils.fromString((String)preferredCacheClusterAZsListValue));
                }
                ++preferredCacheClusterAZsListIndex;
            }
        }
        if (createReplicationGroupRequest.numNodeGroups() != null) {
            request.addParameter("NumNodeGroups", StringUtils.fromInteger((Integer)createReplicationGroupRequest.numNodeGroups()));
        }
        if (createReplicationGroupRequest.replicasPerNodeGroup() != null) {
            request.addParameter("ReplicasPerNodeGroup", StringUtils.fromInteger((Integer)createReplicationGroupRequest.replicasPerNodeGroup()));
        }
        if (!(nodeGroupConfigurationList = (SdkInternalList)createReplicationGroupRequest.nodeGroupConfiguration()).isEmpty() || !nodeGroupConfigurationList.isAutoConstruct()) {
            int nodeGroupConfigurationListIndex = 1;
            for (Object nodeGroupConfigurationListValue : nodeGroupConfigurationList) {
                SdkInternalList replicaAvailabilityZonesList;
                if (((NodeGroupConfiguration)nodeGroupConfigurationListValue).slots() != null) {
                    request.addParameter("NodeGroupConfiguration.NodeGroupConfiguration." + nodeGroupConfigurationListIndex + ".Slots", StringUtils.fromString((String)((NodeGroupConfiguration)nodeGroupConfigurationListValue).slots()));
                }
                if (((NodeGroupConfiguration)nodeGroupConfigurationListValue).replicaCount() != null) {
                    request.addParameter("NodeGroupConfiguration.NodeGroupConfiguration." + nodeGroupConfigurationListIndex + ".ReplicaCount", StringUtils.fromInteger((Integer)((NodeGroupConfiguration)nodeGroupConfigurationListValue).replicaCount()));
                }
                if (((NodeGroupConfiguration)nodeGroupConfigurationListValue).primaryAvailabilityZone() != null) {
                    request.addParameter("NodeGroupConfiguration.NodeGroupConfiguration." + nodeGroupConfigurationListIndex + ".PrimaryAvailabilityZone", StringUtils.fromString((String)((NodeGroupConfiguration)nodeGroupConfigurationListValue).primaryAvailabilityZone()));
                }
                if (!(replicaAvailabilityZonesList = (SdkInternalList)((NodeGroupConfiguration)nodeGroupConfigurationListValue).replicaAvailabilityZones()).isEmpty() || !replicaAvailabilityZonesList.isAutoConstruct()) {
                    int replicaAvailabilityZonesListIndex = 1;
                    for (String replicaAvailabilityZonesListValue : replicaAvailabilityZonesList) {
                        if (replicaAvailabilityZonesListValue != null) {
                            request.addParameter("NodeGroupConfiguration.NodeGroupConfiguration." + nodeGroupConfigurationListIndex + ".ReplicaAvailabilityZones.AvailabilityZone." + replicaAvailabilityZonesListIndex, StringUtils.fromString((String)replicaAvailabilityZonesListValue));
                        }
                        ++replicaAvailabilityZonesListIndex;
                    }
                }
                ++nodeGroupConfigurationListIndex;
            }
        }
        if (createReplicationGroupRequest.cacheNodeType() != null) {
            request.addParameter("CacheNodeType", StringUtils.fromString((String)createReplicationGroupRequest.cacheNodeType()));
        }
        if (createReplicationGroupRequest.engine() != null) {
            request.addParameter("Engine", StringUtils.fromString((String)createReplicationGroupRequest.engine()));
        }
        if (createReplicationGroupRequest.engineVersion() != null) {
            request.addParameter("EngineVersion", StringUtils.fromString((String)createReplicationGroupRequest.engineVersion()));
        }
        if (createReplicationGroupRequest.cacheParameterGroupName() != null) {
            request.addParameter("CacheParameterGroupName", StringUtils.fromString((String)createReplicationGroupRequest.cacheParameterGroupName()));
        }
        if (createReplicationGroupRequest.cacheSubnetGroupName() != null) {
            request.addParameter("CacheSubnetGroupName", StringUtils.fromString((String)createReplicationGroupRequest.cacheSubnetGroupName()));
        }
        if (!(cacheSecurityGroupNamesList = (SdkInternalList)createReplicationGroupRequest.cacheSecurityGroupNames()).isEmpty() || !cacheSecurityGroupNamesList.isAutoConstruct()) {
            int cacheSecurityGroupNamesListIndex = 1;
            for (Object cacheSecurityGroupNamesListValue : cacheSecurityGroupNamesList) {
                if (cacheSecurityGroupNamesListValue != null) {
                    request.addParameter("CacheSecurityGroupNames.CacheSecurityGroupName." + cacheSecurityGroupNamesListIndex, StringUtils.fromString((String)cacheSecurityGroupNamesListValue));
                }
                ++cacheSecurityGroupNamesListIndex;
            }
        }
        if (!(securityGroupIdsList = (SdkInternalList)createReplicationGroupRequest.securityGroupIds()).isEmpty() || !securityGroupIdsList.isAutoConstruct()) {
            int securityGroupIdsListIndex = 1;
            for (String securityGroupIdsListValue : securityGroupIdsList) {
                if (securityGroupIdsListValue != null) {
                    request.addParameter("SecurityGroupIds.SecurityGroupId." + securityGroupIdsListIndex, StringUtils.fromString((String)securityGroupIdsListValue));
                }
                ++securityGroupIdsListIndex;
            }
        }
        if (!(tagsList = (SdkInternalList)createReplicationGroupRequest.tags()).isEmpty() || !tagsList.isAutoConstruct()) {
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue.key() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Key", StringUtils.fromString((String)tagsListValue.key()));
                }
                if (tagsListValue.value() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Value", StringUtils.fromString((String)tagsListValue.value()));
                }
                ++tagsListIndex;
            }
        }
        if (!(snapshotArnsList = (SdkInternalList)createReplicationGroupRequest.snapshotArns()).isEmpty() || !snapshotArnsList.isAutoConstruct()) {
            int snapshotArnsListIndex = 1;
            for (String snapshotArnsListValue : snapshotArnsList) {
                if (snapshotArnsListValue != null) {
                    request.addParameter("SnapshotArns.SnapshotArn." + snapshotArnsListIndex, StringUtils.fromString((String)snapshotArnsListValue));
                }
                ++snapshotArnsListIndex;
            }
        }
        if (createReplicationGroupRequest.snapshotName() != null) {
            request.addParameter("SnapshotName", StringUtils.fromString((String)createReplicationGroupRequest.snapshotName()));
        }
        if (createReplicationGroupRequest.preferredMaintenanceWindow() != null) {
            request.addParameter("PreferredMaintenanceWindow", StringUtils.fromString((String)createReplicationGroupRequest.preferredMaintenanceWindow()));
        }
        if (createReplicationGroupRequest.port() != null) {
            request.addParameter("Port", StringUtils.fromInteger((Integer)createReplicationGroupRequest.port()));
        }
        if (createReplicationGroupRequest.notificationTopicArn() != null) {
            request.addParameter("NotificationTopicArn", StringUtils.fromString((String)createReplicationGroupRequest.notificationTopicArn()));
        }
        if (createReplicationGroupRequest.autoMinorVersionUpgrade() != null) {
            request.addParameter("AutoMinorVersionUpgrade", StringUtils.fromBoolean((Boolean)createReplicationGroupRequest.autoMinorVersionUpgrade()));
        }
        if (createReplicationGroupRequest.snapshotRetentionLimit() != null) {
            request.addParameter("SnapshotRetentionLimit", StringUtils.fromInteger((Integer)createReplicationGroupRequest.snapshotRetentionLimit()));
        }
        if (createReplicationGroupRequest.snapshotWindow() != null) {
            request.addParameter("SnapshotWindow", StringUtils.fromString((String)createReplicationGroupRequest.snapshotWindow()));
        }
        if (createReplicationGroupRequest.authToken() != null) {
            request.addParameter("AuthToken", StringUtils.fromString((String)createReplicationGroupRequest.authToken()));
        }
        return request;
    }
}

