/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.elasticache.model.KeyListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RemoveTagsFromResourceRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, RemoveTagsFromResourceRequest> {
    private final String resourceName;
    private final List<String> tagKeys;

    private RemoveTagsFromResourceRequest(BuilderImpl builder) {
        this.resourceName = builder.resourceName;
        this.tagKeys = builder.tagKeys;
    }

    public String resourceName() {
        return this.resourceName;
    }

    public List<String> tagKeys() {
        return this.tagKeys;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.resourceName() == null ? 0 : this.resourceName().hashCode());
        hashCode = 31 * hashCode + (this.tagKeys() == null ? 0 : this.tagKeys().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemoveTagsFromResourceRequest)) {
            return false;
        }
        RemoveTagsFromResourceRequest other = (RemoveTagsFromResourceRequest)((Object)obj);
        if (other.resourceName() == null ^ this.resourceName() == null) {
            return false;
        }
        if (other.resourceName() != null && !other.resourceName().equals(this.resourceName())) {
            return false;
        }
        if (other.tagKeys() == null ^ this.tagKeys() == null) {
            return false;
        }
        return other.tagKeys() == null || other.tagKeys().equals(this.tagKeys());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.resourceName() != null) {
            sb.append("ResourceName: ").append(this.resourceName()).append(",");
        }
        if (this.tagKeys() != null) {
            sb.append("TagKeys: ").append(this.tagKeys()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String resourceName;
        private List<String> tagKeys = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(RemoveTagsFromResourceRequest model) {
            this.setResourceName(model.resourceName);
            this.setTagKeys(model.tagKeys);
        }

        public final String getResourceName() {
            return this.resourceName;
        }

        @Override
        public final Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        public final void setResourceName(String resourceName) {
            this.resourceName = resourceName;
        }

        public final Collection<String> getTagKeys() {
            return this.tagKeys;
        }

        @Override
        public final Builder tagKeys(Collection<String> tagKeys) {
            this.tagKeys = KeyListCopier.copy(tagKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagKeys(String ... tagKeys) {
            if (this.tagKeys == null) {
                this.tagKeys = new SdkInternalList(tagKeys.length);
            }
            for (String e : tagKeys) {
                this.tagKeys.add(e);
            }
            return this;
        }

        public final void setTagKeys(Collection<String> tagKeys) {
            this.tagKeys = KeyListCopier.copy(tagKeys);
        }

        @SafeVarargs
        public final void setTagKeys(String ... tagKeys) {
            if (this.tagKeys == null) {
                this.tagKeys = new SdkInternalList(tagKeys.length);
            }
            for (String e : tagKeys) {
                this.tagKeys.add(e);
            }
        }

        public RemoveTagsFromResourceRequest build() {
            return new RemoveTagsFromResourceRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RemoveTagsFromResourceRequest> {
        public Builder resourceName(String var1);

        public Builder tagKeys(Collection<String> var1);

        public Builder tagKeys(String ... var1);
    }
}

