/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.elasticache.model.ReservedCacheNodesOffering;
import software.amazon.awssdk.services.elasticache.model.ReservedCacheNodesOfferingListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeReservedCacheNodesOfferingsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeReservedCacheNodesOfferingsResponse> {
    private final String marker;
    private final List<ReservedCacheNodesOffering> reservedCacheNodesOfferings;

    private DescribeReservedCacheNodesOfferingsResponse(BuilderImpl builder) {
        this.marker = builder.marker;
        this.reservedCacheNodesOfferings = builder.reservedCacheNodesOfferings;
    }

    public String marker() {
        return this.marker;
    }

    public List<ReservedCacheNodesOffering> reservedCacheNodesOfferings() {
        return this.reservedCacheNodesOfferings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.marker() == null ? 0 : this.marker().hashCode());
        hashCode = 31 * hashCode + (this.reservedCacheNodesOfferings() == null ? 0 : this.reservedCacheNodesOfferings().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReservedCacheNodesOfferingsResponse)) {
            return false;
        }
        DescribeReservedCacheNodesOfferingsResponse other = (DescribeReservedCacheNodesOfferingsResponse)((Object)obj);
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        if (other.marker() != null && !other.marker().equals(this.marker())) {
            return false;
        }
        if (other.reservedCacheNodesOfferings() == null ^ this.reservedCacheNodesOfferings() == null) {
            return false;
        }
        return other.reservedCacheNodesOfferings() == null || other.reservedCacheNodesOfferings().equals(this.reservedCacheNodesOfferings());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        if (this.reservedCacheNodesOfferings() != null) {
            sb.append("ReservedCacheNodesOfferings: ").append(this.reservedCacheNodesOfferings()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String marker;
        private List<ReservedCacheNodesOffering> reservedCacheNodesOfferings = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReservedCacheNodesOfferingsResponse model) {
            this.setMarker(model.marker);
            this.setReservedCacheNodesOfferings(model.reservedCacheNodesOfferings);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<ReservedCacheNodesOffering> getReservedCacheNodesOfferings() {
            return this.reservedCacheNodesOfferings;
        }

        @Override
        public final Builder reservedCacheNodesOfferings(Collection<ReservedCacheNodesOffering> reservedCacheNodesOfferings) {
            this.reservedCacheNodesOfferings = ReservedCacheNodesOfferingListCopier.copy(reservedCacheNodesOfferings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedCacheNodesOfferings(ReservedCacheNodesOffering ... reservedCacheNodesOfferings) {
            if (this.reservedCacheNodesOfferings == null) {
                this.reservedCacheNodesOfferings = new SdkInternalList(reservedCacheNodesOfferings.length);
            }
            for (ReservedCacheNodesOffering e : reservedCacheNodesOfferings) {
                this.reservedCacheNodesOfferings.add(e);
            }
            return this;
        }

        public final void setReservedCacheNodesOfferings(Collection<ReservedCacheNodesOffering> reservedCacheNodesOfferings) {
            this.reservedCacheNodesOfferings = ReservedCacheNodesOfferingListCopier.copy(reservedCacheNodesOfferings);
        }

        @SafeVarargs
        public final void setReservedCacheNodesOfferings(ReservedCacheNodesOffering ... reservedCacheNodesOfferings) {
            if (this.reservedCacheNodesOfferings == null) {
                this.reservedCacheNodesOfferings = new SdkInternalList(reservedCacheNodesOfferings.length);
            }
            for (ReservedCacheNodesOffering e : reservedCacheNodesOfferings) {
                this.reservedCacheNodesOfferings.add(e);
            }
        }

        public DescribeReservedCacheNodesOfferingsResponse build() {
            return new DescribeReservedCacheNodesOfferingsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeReservedCacheNodesOfferingsResponse> {
        public Builder marker(String var1);

        public Builder reservedCacheNodesOfferings(Collection<ReservedCacheNodesOffering> var1);

        public Builder reservedCacheNodesOfferings(ReservedCacheNodesOffering ... var1);
    }
}

