/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.elasticache.model.CacheCluster;
import software.amazon.awssdk.services.elasticache.model.CacheClusterListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeCacheClustersResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeCacheClustersResponse> {
    private final String marker;
    private final List<CacheCluster> cacheClusters;

    private DescribeCacheClustersResponse(BuilderImpl builder) {
        this.marker = builder.marker;
        this.cacheClusters = builder.cacheClusters;
    }

    public String marker() {
        return this.marker;
    }

    public List<CacheCluster> cacheClusters() {
        return this.cacheClusters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.marker() == null ? 0 : this.marker().hashCode());
        hashCode = 31 * hashCode + (this.cacheClusters() == null ? 0 : this.cacheClusters().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCacheClustersResponse)) {
            return false;
        }
        DescribeCacheClustersResponse other = (DescribeCacheClustersResponse)((Object)obj);
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        if (other.marker() != null && !other.marker().equals(this.marker())) {
            return false;
        }
        if (other.cacheClusters() == null ^ this.cacheClusters() == null) {
            return false;
        }
        return other.cacheClusters() == null || other.cacheClusters().equals(this.cacheClusters());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        if (this.cacheClusters() != null) {
            sb.append("CacheClusters: ").append(this.cacheClusters()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String marker;
        private List<CacheCluster> cacheClusters = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCacheClustersResponse model) {
            this.setMarker(model.marker);
            this.setCacheClusters(model.cacheClusters);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<CacheCluster> getCacheClusters() {
            return this.cacheClusters;
        }

        @Override
        public final Builder cacheClusters(Collection<CacheCluster> cacheClusters) {
            this.cacheClusters = CacheClusterListCopier.copy(cacheClusters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cacheClusters(CacheCluster ... cacheClusters) {
            if (this.cacheClusters == null) {
                this.cacheClusters = new SdkInternalList(cacheClusters.length);
            }
            for (CacheCluster e : cacheClusters) {
                this.cacheClusters.add(e);
            }
            return this;
        }

        public final void setCacheClusters(Collection<CacheCluster> cacheClusters) {
            this.cacheClusters = CacheClusterListCopier.copy(cacheClusters);
        }

        @SafeVarargs
        public final void setCacheClusters(CacheCluster ... cacheClusters) {
            if (this.cacheClusters == null) {
                this.cacheClusters = new SdkInternalList(cacheClusters.length);
            }
            for (CacheCluster e : cacheClusters) {
                this.cacheClusters.add(e);
            }
        }

        public DescribeCacheClustersResponse build() {
            return new DescribeCacheClustersResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeCacheClustersResponse> {
        public Builder marker(String var1);

        public Builder cacheClusters(Collection<CacheCluster> var1);

        public Builder cacheClusters(CacheCluster ... var1);
    }
}

