/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.eks.model.LogSetup;
import software.amazon.awssdk.services.eks.model.LogSetupsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Logging
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Logging> {
    private static final SdkField<List<LogSetup>> CLUSTER_LOGGING_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(Logging.getter(Logging::clusterLogging)).setter(Logging.setter(Builder::clusterLogging)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterLogging").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LogSetup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_LOGGING_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<LogSetup> clusterLogging;

    private Logging(BuilderImpl builder) {
        this.clusterLogging = builder.clusterLogging;
    }

    public List<LogSetup> clusterLogging() {
        return this.clusterLogging;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterLogging());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Logging)) {
            return false;
        }
        Logging other = (Logging)obj;
        return Objects.equals(this.clusterLogging(), other.clusterLogging());
    }

    public String toString() {
        return ToString.builder((String)"Logging").add("ClusterLogging", this.clusterLogging()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clusterLogging": {
                return Optional.ofNullable(clazz.cast(this.clusterLogging()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Logging, T> g) {
        return obj -> g.apply((Logging)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<LogSetup> clusterLogging = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Logging model) {
            this.clusterLogging(model.clusterLogging);
        }

        public final Collection<LogSetup.Builder> getClusterLogging() {
            return this.clusterLogging != null ? (Collection)this.clusterLogging.stream().map(LogSetup::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder clusterLogging(Collection<LogSetup> clusterLogging) {
            this.clusterLogging = LogSetupsCopier.copy(clusterLogging);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusterLogging(LogSetup ... clusterLogging) {
            this.clusterLogging(Arrays.asList(clusterLogging));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusterLogging(Consumer<LogSetup.Builder> ... clusterLogging) {
            this.clusterLogging(Stream.of(clusterLogging).map(c -> (LogSetup)((LogSetup.Builder)LogSetup.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setClusterLogging(Collection<LogSetup.BuilderImpl> clusterLogging) {
            this.clusterLogging = LogSetupsCopier.copyFromBuilder(clusterLogging);
        }

        public Logging build() {
            return new Logging(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Logging> {
        public Builder clusterLogging(Collection<LogSetup> var1);

        public Builder clusterLogging(LogSetup ... var1);

        public Builder clusterLogging(Consumer<LogSetup.Builder> ... var1);
    }
}

