/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.eks.model.CapabilityDeletePropagationPolicy;
import software.amazon.awssdk.services.eks.model.EksRequest;
import software.amazon.awssdk.services.eks.model.UpdateCapabilityConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateCapabilityRequest
extends EksRequest
implements ToCopyableBuilder<Builder, UpdateCapabilityRequest> {
    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clusterName").getter(UpdateCapabilityRequest.getter(UpdateCapabilityRequest::clusterName)).setter(UpdateCapabilityRequest.setter(Builder::clusterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("name").build()}).build();
    private static final SdkField<String> CAPABILITY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("capabilityName").getter(UpdateCapabilityRequest.getter(UpdateCapabilityRequest::capabilityName)).setter(UpdateCapabilityRequest.setter(Builder::capabilityName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("capabilityName").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(UpdateCapabilityRequest.getter(UpdateCapabilityRequest::roleArn)).setter(UpdateCapabilityRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<UpdateCapabilityConfiguration> CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("configuration").getter(UpdateCapabilityRequest.getter(UpdateCapabilityRequest::configuration)).setter(UpdateCapabilityRequest.setter(Builder::configuration)).constructor(UpdateCapabilityConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientRequestToken").getter(UpdateCapabilityRequest.getter(UpdateCapabilityRequest::clientRequestToken)).setter(UpdateCapabilityRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> DELETE_PROPAGATION_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("deletePropagationPolicy").getter(UpdateCapabilityRequest.getter(UpdateCapabilityRequest::deletePropagationPolicyAsString)).setter(UpdateCapabilityRequest.setter(Builder::deletePropagationPolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deletePropagationPolicy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_NAME_FIELD, CAPABILITY_NAME_FIELD, ROLE_ARN_FIELD, CONFIGURATION_FIELD, CLIENT_REQUEST_TOKEN_FIELD, DELETE_PROPAGATION_POLICY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateCapabilityRequest.memberNameToFieldInitializer();
    private final String clusterName;
    private final String capabilityName;
    private final String roleArn;
    private final UpdateCapabilityConfiguration configuration;
    private final String clientRequestToken;
    private final String deletePropagationPolicy;

    private UpdateCapabilityRequest(BuilderImpl builder) {
        super(builder);
        this.clusterName = builder.clusterName;
        this.capabilityName = builder.capabilityName;
        this.roleArn = builder.roleArn;
        this.configuration = builder.configuration;
        this.clientRequestToken = builder.clientRequestToken;
        this.deletePropagationPolicy = builder.deletePropagationPolicy;
    }

    public final String clusterName() {
        return this.clusterName;
    }

    public final String capabilityName() {
        return this.capabilityName;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final UpdateCapabilityConfiguration configuration() {
        return this.configuration;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    public final CapabilityDeletePropagationPolicy deletePropagationPolicy() {
        return CapabilityDeletePropagationPolicy.fromValue(this.deletePropagationPolicy);
    }

    public final String deletePropagationPolicyAsString() {
        return this.deletePropagationPolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.capabilityName());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.configuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.deletePropagationPolicyAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateCapabilityRequest)) {
            return false;
        }
        UpdateCapabilityRequest other = (UpdateCapabilityRequest)((Object)obj);
        return Objects.equals(this.clusterName(), other.clusterName()) && Objects.equals(this.capabilityName(), other.capabilityName()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.configuration(), other.configuration()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && Objects.equals(this.deletePropagationPolicyAsString(), other.deletePropagationPolicyAsString());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateCapabilityRequest").add("ClusterName", (Object)this.clusterName()).add("CapabilityName", (Object)this.capabilityName()).add("RoleArn", (Object)this.roleArn()).add("Configuration", (Object)this.configuration()).add("ClientRequestToken", (Object)this.clientRequestToken()).add("DeletePropagationPolicy", (Object)this.deletePropagationPolicyAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clusterName": {
                return Optional.ofNullable(clazz.cast(this.clusterName()));
            }
            case "capabilityName": {
                return Optional.ofNullable(clazz.cast(this.capabilityName()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "configuration": {
                return Optional.ofNullable(clazz.cast(this.configuration()));
            }
            case "clientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
            case "deletePropagationPolicy": {
                return Optional.ofNullable(clazz.cast(this.deletePropagationPolicyAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", CLUSTER_NAME_FIELD);
        map.put("capabilityName", CAPABILITY_NAME_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("configuration", CONFIGURATION_FIELD);
        map.put("clientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
        map.put("deletePropagationPolicy", DELETE_PROPAGATION_POLICY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateCapabilityRequest, T> g) {
        return obj -> g.apply((UpdateCapabilityRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EksRequest.BuilderImpl
    implements Builder {
        private String clusterName;
        private String capabilityName;
        private String roleArn;
        private UpdateCapabilityConfiguration configuration;
        private String clientRequestToken;
        private String deletePropagationPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateCapabilityRequest model) {
            super(model);
            this.clusterName(model.clusterName);
            this.capabilityName(model.capabilityName);
            this.roleArn(model.roleArn);
            this.configuration(model.configuration);
            this.clientRequestToken(model.clientRequestToken);
            this.deletePropagationPolicy(model.deletePropagationPolicy);
        }

        public final String getClusterName() {
            return this.clusterName;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final String getCapabilityName() {
            return this.capabilityName;
        }

        public final void setCapabilityName(String capabilityName) {
            this.capabilityName = capabilityName;
        }

        @Override
        public final Builder capabilityName(String capabilityName) {
            this.capabilityName = capabilityName;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final UpdateCapabilityConfiguration.Builder getConfiguration() {
            return this.configuration != null ? this.configuration.toBuilder() : null;
        }

        public final void setConfiguration(UpdateCapabilityConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(UpdateCapabilityConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final String getDeletePropagationPolicy() {
            return this.deletePropagationPolicy;
        }

        public final void setDeletePropagationPolicy(String deletePropagationPolicy) {
            this.deletePropagationPolicy = deletePropagationPolicy;
        }

        @Override
        public final Builder deletePropagationPolicy(String deletePropagationPolicy) {
            this.deletePropagationPolicy = deletePropagationPolicy;
            return this;
        }

        @Override
        public final Builder deletePropagationPolicy(CapabilityDeletePropagationPolicy deletePropagationPolicy) {
            this.deletePropagationPolicy(deletePropagationPolicy == null ? null : deletePropagationPolicy.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateCapabilityRequest build() {
            return new UpdateCapabilityRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends EksRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateCapabilityRequest> {
        public Builder clusterName(String var1);

        public Builder capabilityName(String var1);

        public Builder roleArn(String var1);

        public Builder configuration(UpdateCapabilityConfiguration var1);

        default public Builder configuration(Consumer<UpdateCapabilityConfiguration.Builder> configuration) {
            return this.configuration((UpdateCapabilityConfiguration)((UpdateCapabilityConfiguration.Builder)UpdateCapabilityConfiguration.builder().applyMutation(configuration)).build());
        }

        public Builder clientRequestToken(String var1);

        public Builder deletePropagationPolicy(String var1);

        public Builder deletePropagationPolicy(CapabilityDeletePropagationPolicy var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

