/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SsoIdentityType {
    SSO_USER("SSO_USER"),
    SSO_GROUP("SSO_GROUP"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SsoIdentityType> VALUE_MAP;
    private final String value;

    private SsoIdentityType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SsoIdentityType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SsoIdentityType> knownValues() {
        EnumSet<SsoIdentityType> knownValues = EnumSet.allOf(SsoIdentityType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SsoIdentityType.class, SsoIdentityType::toString);
    }
}

