/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.eks.model.AdditionalInfoMapCopier;
import software.amazon.awssdk.services.eks.model.Category;
import software.amazon.awssdk.services.eks.model.InsightCategorySpecificSummary;
import software.amazon.awssdk.services.eks.model.InsightResourceDetail;
import software.amazon.awssdk.services.eks.model.InsightResourceDetailsCopier;
import software.amazon.awssdk.services.eks.model.InsightStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Insight
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Insight> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(Insight.getter(Insight::id)).setter(Insight.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(Insight.getter(Insight::name)).setter(Insight.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> CATEGORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("category").getter(Insight.getter(Insight::categoryAsString)).setter(Insight.setter(Builder::category)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("category").build()}).build();
    private static final SdkField<String> KUBERNETES_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("kubernetesVersion").getter(Insight.getter(Insight::kubernetesVersion)).setter(Insight.setter(Builder::kubernetesVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kubernetesVersion").build()}).build();
    private static final SdkField<Instant> LAST_REFRESH_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastRefreshTime").getter(Insight.getter(Insight::lastRefreshTime)).setter(Insight.setter(Builder::lastRefreshTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastRefreshTime").build()}).build();
    private static final SdkField<Instant> LAST_TRANSITION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastTransitionTime").getter(Insight.getter(Insight::lastTransitionTime)).setter(Insight.setter(Builder::lastTransitionTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastTransitionTime").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(Insight.getter(Insight::description)).setter(Insight.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<InsightStatus> INSIGHT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("insightStatus").getter(Insight.getter(Insight::insightStatus)).setter(Insight.setter(Builder::insightStatus)).constructor(InsightStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("insightStatus").build()}).build();
    private static final SdkField<String> RECOMMENDATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("recommendation").getter(Insight.getter(Insight::recommendation)).setter(Insight.setter(Builder::recommendation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendation").build()}).build();
    private static final SdkField<Map<String, String>> ADDITIONAL_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("additionalInfo").getter(Insight.getter(Insight::additionalInfo)).setter(Insight.setter(Builder::additionalInfo)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalInfo").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<InsightResourceDetail>> RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("resources").getter(Insight.getter(Insight::resources)).setter(Insight.setter(Builder::resources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InsightResourceDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<InsightCategorySpecificSummary> CATEGORY_SPECIFIC_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("categorySpecificSummary").getter(Insight.getter(Insight::categorySpecificSummary)).setter(Insight.setter(Builder::categorySpecificSummary)).constructor(InsightCategorySpecificSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("categorySpecificSummary").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD, CATEGORY_FIELD, KUBERNETES_VERSION_FIELD, LAST_REFRESH_TIME_FIELD, LAST_TRANSITION_TIME_FIELD, DESCRIPTION_FIELD, INSIGHT_STATUS_FIELD, RECOMMENDATION_FIELD, ADDITIONAL_INFO_FIELD, RESOURCES_FIELD, CATEGORY_SPECIFIC_SUMMARY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Insight.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String name;
    private final String category;
    private final String kubernetesVersion;
    private final Instant lastRefreshTime;
    private final Instant lastTransitionTime;
    private final String description;
    private final InsightStatus insightStatus;
    private final String recommendation;
    private final Map<String, String> additionalInfo;
    private final List<InsightResourceDetail> resources;
    private final InsightCategorySpecificSummary categorySpecificSummary;

    private Insight(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.category = builder.category;
        this.kubernetesVersion = builder.kubernetesVersion;
        this.lastRefreshTime = builder.lastRefreshTime;
        this.lastTransitionTime = builder.lastTransitionTime;
        this.description = builder.description;
        this.insightStatus = builder.insightStatus;
        this.recommendation = builder.recommendation;
        this.additionalInfo = builder.additionalInfo;
        this.resources = builder.resources;
        this.categorySpecificSummary = builder.categorySpecificSummary;
    }

    public final String id() {
        return this.id;
    }

    public final String name() {
        return this.name;
    }

    public final Category category() {
        return Category.fromValue(this.category);
    }

    public final String categoryAsString() {
        return this.category;
    }

    public final String kubernetesVersion() {
        return this.kubernetesVersion;
    }

    public final Instant lastRefreshTime() {
        return this.lastRefreshTime;
    }

    public final Instant lastTransitionTime() {
        return this.lastTransitionTime;
    }

    public final String description() {
        return this.description;
    }

    public final InsightStatus insightStatus() {
        return this.insightStatus;
    }

    public final String recommendation() {
        return this.recommendation;
    }

    public final boolean hasAdditionalInfo() {
        return this.additionalInfo != null && !(this.additionalInfo instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> additionalInfo() {
        return this.additionalInfo;
    }

    public final boolean hasResources() {
        return this.resources != null && !(this.resources instanceof SdkAutoConstructList);
    }

    public final List<InsightResourceDetail> resources() {
        return this.resources;
    }

    public final InsightCategorySpecificSummary categorySpecificSummary() {
        return this.categorySpecificSummary;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.categoryAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.kubernetesVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastRefreshTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastTransitionTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.insightStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.recommendation());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdditionalInfo() ? this.additionalInfo() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResources() ? this.resources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.categorySpecificSummary());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Insight)) {
            return false;
        }
        Insight other = (Insight)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.categoryAsString(), other.categoryAsString()) && Objects.equals(this.kubernetesVersion(), other.kubernetesVersion()) && Objects.equals(this.lastRefreshTime(), other.lastRefreshTime()) && Objects.equals(this.lastTransitionTime(), other.lastTransitionTime()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.insightStatus(), other.insightStatus()) && Objects.equals(this.recommendation(), other.recommendation()) && this.hasAdditionalInfo() == other.hasAdditionalInfo() && Objects.equals(this.additionalInfo(), other.additionalInfo()) && this.hasResources() == other.hasResources() && Objects.equals(this.resources(), other.resources()) && Objects.equals(this.categorySpecificSummary(), other.categorySpecificSummary());
    }

    public final String toString() {
        return ToString.builder((String)"Insight").add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("Category", (Object)this.categoryAsString()).add("KubernetesVersion", (Object)this.kubernetesVersion()).add("LastRefreshTime", (Object)this.lastRefreshTime()).add("LastTransitionTime", (Object)this.lastTransitionTime()).add("Description", (Object)this.description()).add("InsightStatus", (Object)this.insightStatus()).add("Recommendation", (Object)this.recommendation()).add("AdditionalInfo", this.hasAdditionalInfo() ? this.additionalInfo() : null).add("Resources", this.hasResources() ? this.resources() : null).add("CategorySpecificSummary", (Object)this.categorySpecificSummary()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "category": {
                return Optional.ofNullable(clazz.cast(this.categoryAsString()));
            }
            case "kubernetesVersion": {
                return Optional.ofNullable(clazz.cast(this.kubernetesVersion()));
            }
            case "lastRefreshTime": {
                return Optional.ofNullable(clazz.cast(this.lastRefreshTime()));
            }
            case "lastTransitionTime": {
                return Optional.ofNullable(clazz.cast(this.lastTransitionTime()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "insightStatus": {
                return Optional.ofNullable(clazz.cast(this.insightStatus()));
            }
            case "recommendation": {
                return Optional.ofNullable(clazz.cast(this.recommendation()));
            }
            case "additionalInfo": {
                return Optional.ofNullable(clazz.cast(this.additionalInfo()));
            }
            case "resources": {
                return Optional.ofNullable(clazz.cast(this.resources()));
            }
            case "categorySpecificSummary": {
                return Optional.ofNullable(clazz.cast(this.categorySpecificSummary()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("category", CATEGORY_FIELD);
        map.put("kubernetesVersion", KUBERNETES_VERSION_FIELD);
        map.put("lastRefreshTime", LAST_REFRESH_TIME_FIELD);
        map.put("lastTransitionTime", LAST_TRANSITION_TIME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("insightStatus", INSIGHT_STATUS_FIELD);
        map.put("recommendation", RECOMMENDATION_FIELD);
        map.put("additionalInfo", ADDITIONAL_INFO_FIELD);
        map.put("resources", RESOURCES_FIELD);
        map.put("categorySpecificSummary", CATEGORY_SPECIFIC_SUMMARY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Insight, T> g) {
        return obj -> g.apply((Insight)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String name;
        private String category;
        private String kubernetesVersion;
        private Instant lastRefreshTime;
        private Instant lastTransitionTime;
        private String description;
        private InsightStatus insightStatus;
        private String recommendation;
        private Map<String, String> additionalInfo = DefaultSdkAutoConstructMap.getInstance();
        private List<InsightResourceDetail> resources = DefaultSdkAutoConstructList.getInstance();
        private InsightCategorySpecificSummary categorySpecificSummary;

        private BuilderImpl() {
        }

        private BuilderImpl(Insight model) {
            this.id(model.id);
            this.name(model.name);
            this.category(model.category);
            this.kubernetesVersion(model.kubernetesVersion);
            this.lastRefreshTime(model.lastRefreshTime);
            this.lastTransitionTime(model.lastTransitionTime);
            this.description(model.description);
            this.insightStatus(model.insightStatus);
            this.recommendation(model.recommendation);
            this.additionalInfo(model.additionalInfo);
            this.resources(model.resources);
            this.categorySpecificSummary(model.categorySpecificSummary);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getCategory() {
            return this.category;
        }

        public final void setCategory(String category) {
            this.category = category;
        }

        @Override
        public final Builder category(String category) {
            this.category = category;
            return this;
        }

        @Override
        public final Builder category(Category category) {
            this.category(category == null ? null : category.toString());
            return this;
        }

        public final String getKubernetesVersion() {
            return this.kubernetesVersion;
        }

        public final void setKubernetesVersion(String kubernetesVersion) {
            this.kubernetesVersion = kubernetesVersion;
        }

        @Override
        public final Builder kubernetesVersion(String kubernetesVersion) {
            this.kubernetesVersion = kubernetesVersion;
            return this;
        }

        public final Instant getLastRefreshTime() {
            return this.lastRefreshTime;
        }

        public final void setLastRefreshTime(Instant lastRefreshTime) {
            this.lastRefreshTime = lastRefreshTime;
        }

        @Override
        public final Builder lastRefreshTime(Instant lastRefreshTime) {
            this.lastRefreshTime = lastRefreshTime;
            return this;
        }

        public final Instant getLastTransitionTime() {
            return this.lastTransitionTime;
        }

        public final void setLastTransitionTime(Instant lastTransitionTime) {
            this.lastTransitionTime = lastTransitionTime;
        }

        @Override
        public final Builder lastTransitionTime(Instant lastTransitionTime) {
            this.lastTransitionTime = lastTransitionTime;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final InsightStatus.Builder getInsightStatus() {
            return this.insightStatus != null ? this.insightStatus.toBuilder() : null;
        }

        public final void setInsightStatus(InsightStatus.BuilderImpl insightStatus) {
            this.insightStatus = insightStatus != null ? insightStatus.build() : null;
        }

        @Override
        public final Builder insightStatus(InsightStatus insightStatus) {
            this.insightStatus = insightStatus;
            return this;
        }

        public final String getRecommendation() {
            return this.recommendation;
        }

        public final void setRecommendation(String recommendation) {
            this.recommendation = recommendation;
        }

        @Override
        public final Builder recommendation(String recommendation) {
            this.recommendation = recommendation;
            return this;
        }

        public final Map<String, String> getAdditionalInfo() {
            if (this.additionalInfo instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.additionalInfo;
        }

        public final void setAdditionalInfo(Map<String, String> additionalInfo) {
            this.additionalInfo = AdditionalInfoMapCopier.copy(additionalInfo);
        }

        @Override
        public final Builder additionalInfo(Map<String, String> additionalInfo) {
            this.additionalInfo = AdditionalInfoMapCopier.copy(additionalInfo);
            return this;
        }

        public final List<InsightResourceDetail.Builder> getResources() {
            List<InsightResourceDetail.Builder> result = InsightResourceDetailsCopier.copyToBuilder(this.resources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResources(Collection<InsightResourceDetail.BuilderImpl> resources) {
            this.resources = InsightResourceDetailsCopier.copyFromBuilder(resources);
        }

        @Override
        public final Builder resources(Collection<InsightResourceDetail> resources) {
            this.resources = InsightResourceDetailsCopier.copy(resources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resources(InsightResourceDetail ... resources) {
            this.resources(Arrays.asList(resources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resources(Consumer<InsightResourceDetail.Builder> ... resources) {
            this.resources(Stream.of(resources).map(c -> (InsightResourceDetail)((InsightResourceDetail.Builder)InsightResourceDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final InsightCategorySpecificSummary.Builder getCategorySpecificSummary() {
            return this.categorySpecificSummary != null ? this.categorySpecificSummary.toBuilder() : null;
        }

        public final void setCategorySpecificSummary(InsightCategorySpecificSummary.BuilderImpl categorySpecificSummary) {
            this.categorySpecificSummary = categorySpecificSummary != null ? categorySpecificSummary.build() : null;
        }

        @Override
        public final Builder categorySpecificSummary(InsightCategorySpecificSummary categorySpecificSummary) {
            this.categorySpecificSummary = categorySpecificSummary;
            return this;
        }

        public Insight build() {
            return new Insight(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Insight> {
        public Builder id(String var1);

        public Builder name(String var1);

        public Builder category(String var1);

        public Builder category(Category var1);

        public Builder kubernetesVersion(String var1);

        public Builder lastRefreshTime(Instant var1);

        public Builder lastTransitionTime(Instant var1);

        public Builder description(String var1);

        public Builder insightStatus(InsightStatus var1);

        default public Builder insightStatus(Consumer<InsightStatus.Builder> insightStatus) {
            return this.insightStatus((InsightStatus)((InsightStatus.Builder)InsightStatus.builder().applyMutation(insightStatus)).build());
        }

        public Builder recommendation(String var1);

        public Builder additionalInfo(Map<String, String> var1);

        public Builder resources(Collection<InsightResourceDetail> var1);

        public Builder resources(InsightResourceDetail ... var1);

        public Builder resources(Consumer<InsightResourceDetail.Builder> ... var1);

        public Builder categorySpecificSummary(InsightCategorySpecificSummary var1);

        default public Builder categorySpecificSummary(Consumer<InsightCategorySpecificSummary.Builder> categorySpecificSummary) {
            return this.categorySpecificSummary((InsightCategorySpecificSummary)((InsightCategorySpecificSummary.Builder)InsightCategorySpecificSummary.builder().applyMutation(categorySpecificSummary)).build());
        }
    }
}

