/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.eks.model.EksResponse;
import software.amazon.awssdk.services.eks.model.PodIdentityAssociationSummariesCopier;
import software.amazon.awssdk.services.eks.model.PodIdentityAssociationSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListPodIdentityAssociationsResponse
extends EksResponse
implements ToCopyableBuilder<Builder, ListPodIdentityAssociationsResponse> {
    private static final SdkField<List<PodIdentityAssociationSummary>> ASSOCIATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("associations").getter(ListPodIdentityAssociationsResponse.getter(ListPodIdentityAssociationsResponse::associations)).setter(ListPodIdentityAssociationsResponse.setter(Builder::associations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PodIdentityAssociationSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListPodIdentityAssociationsResponse.getter(ListPodIdentityAssociationsResponse::nextToken)).setter(ListPodIdentityAssociationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATIONS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListPodIdentityAssociationsResponse.memberNameToFieldInitializer();
    private final List<PodIdentityAssociationSummary> associations;
    private final String nextToken;

    private ListPodIdentityAssociationsResponse(BuilderImpl builder) {
        super(builder);
        this.associations = builder.associations;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasAssociations() {
        return this.associations != null && !(this.associations instanceof SdkAutoConstructList);
    }

    public final List<PodIdentityAssociationSummary> associations() {
        return this.associations;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssociations() ? this.associations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPodIdentityAssociationsResponse)) {
            return false;
        }
        ListPodIdentityAssociationsResponse other = (ListPodIdentityAssociationsResponse)((Object)obj);
        return this.hasAssociations() == other.hasAssociations() && Objects.equals(this.associations(), other.associations()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListPodIdentityAssociationsResponse").add("Associations", this.hasAssociations() ? this.associations() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "associations": {
                return Optional.ofNullable(clazz.cast(this.associations()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("associations", ASSOCIATIONS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListPodIdentityAssociationsResponse, T> g) {
        return obj -> g.apply((ListPodIdentityAssociationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EksResponse.BuilderImpl
    implements Builder {
        private List<PodIdentityAssociationSummary> associations = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPodIdentityAssociationsResponse model) {
            super(model);
            this.associations(model.associations);
            this.nextToken(model.nextToken);
        }

        public final List<PodIdentityAssociationSummary.Builder> getAssociations() {
            List<PodIdentityAssociationSummary.Builder> result = PodIdentityAssociationSummariesCopier.copyToBuilder(this.associations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssociations(Collection<PodIdentityAssociationSummary.BuilderImpl> associations) {
            this.associations = PodIdentityAssociationSummariesCopier.copyFromBuilder(associations);
        }

        @Override
        public final Builder associations(Collection<PodIdentityAssociationSummary> associations) {
            this.associations = PodIdentityAssociationSummariesCopier.copy(associations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associations(PodIdentityAssociationSummary ... associations) {
            this.associations(Arrays.asList(associations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associations(Consumer<PodIdentityAssociationSummary.Builder> ... associations) {
            this.associations(Stream.of(associations).map(c -> (PodIdentityAssociationSummary)((PodIdentityAssociationSummary.Builder)PodIdentityAssociationSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListPodIdentityAssociationsResponse build() {
            return new ListPodIdentityAssociationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends EksResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListPodIdentityAssociationsResponse> {
        public Builder associations(Collection<PodIdentityAssociationSummary> var1);

        public Builder associations(PodIdentityAssociationSummary ... var1);

        public Builder associations(Consumer<PodIdentityAssociationSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

