/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.eks.model.ErrorDetail;
import software.amazon.awssdk.services.eks.model.ErrorDetailsCopier;
import software.amazon.awssdk.services.eks.model.UpdateParam;
import software.amazon.awssdk.services.eks.model.UpdateParamsCopier;
import software.amazon.awssdk.services.eks.model.UpdateStatus;
import software.amazon.awssdk.services.eks.model.UpdateType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Update
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Update> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(Update.getter(Update::id)).setter(Update.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(Update.getter(Update::statusAsString)).setter(Update.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(Update.getter(Update::typeAsString)).setter(Update.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<List<UpdateParam>> PARAMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("params").getter(Update.getter(Update::params)).setter(Update.setter(Builder::params)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("params").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UpdateParam::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(Update.getter(Update::createdAt)).setter(Update.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<List<ErrorDetail>> ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("errors").getter(Update.getter(Update::errors)).setter(Update.setter(Builder::errors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ErrorDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, STATUS_FIELD, TYPE_FIELD, PARAMS_FIELD, CREATED_AT_FIELD, ERRORS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Update.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String status;
    private final String type;
    private final List<UpdateParam> params;
    private final Instant createdAt;
    private final List<ErrorDetail> errors;

    private Update(BuilderImpl builder) {
        this.id = builder.id;
        this.status = builder.status;
        this.type = builder.type;
        this.params = builder.params;
        this.createdAt = builder.createdAt;
        this.errors = builder.errors;
    }

    public final String id() {
        return this.id;
    }

    public final UpdateStatus status() {
        return UpdateStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final UpdateType type() {
        return UpdateType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final boolean hasParams() {
        return this.params != null && !(this.params instanceof SdkAutoConstructList);
    }

    public final List<UpdateParam> params() {
        return this.params;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final boolean hasErrors() {
        return this.errors != null && !(this.errors instanceof SdkAutoConstructList);
    }

    public final List<ErrorDetail> errors() {
        return this.errors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParams() ? this.params() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasErrors() ? this.errors() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Update)) {
            return false;
        }
        Update other = (Update)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.typeAsString(), other.typeAsString()) && this.hasParams() == other.hasParams() && Objects.equals(this.params(), other.params()) && Objects.equals(this.createdAt(), other.createdAt()) && this.hasErrors() == other.hasErrors() && Objects.equals(this.errors(), other.errors());
    }

    public final String toString() {
        return ToString.builder((String)"Update").add("Id", (Object)this.id()).add("Status", (Object)this.statusAsString()).add("Type", (Object)this.typeAsString()).add("Params", this.hasParams() ? this.params() : null).add("CreatedAt", (Object)this.createdAt()).add("Errors", this.hasErrors() ? this.errors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "params": {
                return Optional.ofNullable(clazz.cast(this.params()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "errors": {
                return Optional.ofNullable(clazz.cast(this.errors()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", ID_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("params", PARAMS_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("errors", ERRORS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Update, T> g) {
        return obj -> g.apply((Update)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String status;
        private String type;
        private List<UpdateParam> params = DefaultSdkAutoConstructList.getInstance();
        private Instant createdAt;
        private List<ErrorDetail> errors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Update model) {
            this.id(model.id);
            this.status(model.status);
            this.type(model.type);
            this.params(model.params);
            this.createdAt(model.createdAt);
            this.errors(model.errors);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(UpdateStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(UpdateType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final List<UpdateParam.Builder> getParams() {
            List<UpdateParam.Builder> result = UpdateParamsCopier.copyToBuilder(this.params);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setParams(Collection<UpdateParam.BuilderImpl> params) {
            this.params = UpdateParamsCopier.copyFromBuilder(params);
        }

        @Override
        public final Builder params(Collection<UpdateParam> params) {
            this.params = UpdateParamsCopier.copy(params);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder params(UpdateParam ... params) {
            this.params(Arrays.asList(params));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder params(Consumer<UpdateParam.Builder> ... params) {
            this.params(Stream.of(params).map(c -> (UpdateParam)((UpdateParam.Builder)UpdateParam.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final List<ErrorDetail.Builder> getErrors() {
            List<ErrorDetail.Builder> result = ErrorDetailsCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<ErrorDetail.BuilderImpl> errors) {
            this.errors = ErrorDetailsCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<ErrorDetail> errors) {
            this.errors = ErrorDetailsCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(ErrorDetail ... errors) {
            this.errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<ErrorDetail.Builder> ... errors) {
            this.errors(Stream.of(errors).map(c -> (ErrorDetail)((ErrorDetail.Builder)ErrorDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public Update build() {
            return new Update(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Update> {
        public Builder id(String var1);

        public Builder status(String var1);

        public Builder status(UpdateStatus var1);

        public Builder type(String var1);

        public Builder type(UpdateType var1);

        public Builder params(Collection<UpdateParam> var1);

        public Builder params(UpdateParam ... var1);

        public Builder params(Consumer<UpdateParam.Builder> ... var1);

        public Builder createdAt(Instant var1);

        public Builder errors(Collection<ErrorDetail> var1);

        public Builder errors(ErrorDetail ... var1);

        public Builder errors(Consumer<ErrorDetail.Builder> ... var1);
    }
}

