/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.eks.EksClient;
import software.amazon.awssdk.services.eks.internal.UserAgentUtils;
import software.amazon.awssdk.services.eks.model.ClusterVersionInformation;
import software.amazon.awssdk.services.eks.model.DescribeClusterVersionsRequest;
import software.amazon.awssdk.services.eks.model.DescribeClusterVersionsResponse;

public class DescribeClusterVersionsIterable
implements SdkIterable<DescribeClusterVersionsResponse> {
    private final EksClient client;
    private final DescribeClusterVersionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeClusterVersionsIterable(EksClient client, DescribeClusterVersionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeClusterVersionsResponseFetcher();
    }

    public Iterator<DescribeClusterVersionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ClusterVersionInformation> clusterVersions() {
        Function<DescribeClusterVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.clusterVersions() != null) {
                return response.clusterVersions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeClusterVersionsResponseFetcher
    implements SyncPageFetcher<DescribeClusterVersionsResponse> {
        private DescribeClusterVersionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeClusterVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeClusterVersionsResponse nextPage(DescribeClusterVersionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeClusterVersionsIterable.this.client.describeClusterVersions(DescribeClusterVersionsIterable.this.firstRequest);
            }
            return DescribeClusterVersionsIterable.this.client.describeClusterVersions((DescribeClusterVersionsRequest)((Object)DescribeClusterVersionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

