/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.eks.model.EksRequest;
import software.amazon.awssdk.services.eks.model.IdentityProviderConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeIdentityProviderConfigRequest
extends EksRequest
implements ToCopyableBuilder<Builder, DescribeIdentityProviderConfigRequest> {
    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clusterName").getter(DescribeIdentityProviderConfigRequest.getter(DescribeIdentityProviderConfigRequest::clusterName)).setter(DescribeIdentityProviderConfigRequest.setter(Builder::clusterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("name").build()}).build();
    private static final SdkField<IdentityProviderConfig> IDENTITY_PROVIDER_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("identityProviderConfig").getter(DescribeIdentityProviderConfigRequest.getter(DescribeIdentityProviderConfigRequest::identityProviderConfig)).setter(DescribeIdentityProviderConfigRequest.setter(Builder::identityProviderConfig)).constructor(IdentityProviderConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identityProviderConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_NAME_FIELD, IDENTITY_PROVIDER_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeIdentityProviderConfigRequest.memberNameToFieldInitializer();
    private final String clusterName;
    private final IdentityProviderConfig identityProviderConfig;

    private DescribeIdentityProviderConfigRequest(BuilderImpl builder) {
        super(builder);
        this.clusterName = builder.clusterName;
        this.identityProviderConfig = builder.identityProviderConfig;
    }

    public final String clusterName() {
        return this.clusterName;
    }

    public final IdentityProviderConfig identityProviderConfig() {
        return this.identityProviderConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.identityProviderConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeIdentityProviderConfigRequest)) {
            return false;
        }
        DescribeIdentityProviderConfigRequest other = (DescribeIdentityProviderConfigRequest)((Object)obj);
        return Objects.equals(this.clusterName(), other.clusterName()) && Objects.equals(this.identityProviderConfig(), other.identityProviderConfig());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeIdentityProviderConfigRequest").add("ClusterName", (Object)this.clusterName()).add("IdentityProviderConfig", (Object)this.identityProviderConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clusterName": {
                return Optional.ofNullable(clazz.cast(this.clusterName()));
            }
            case "identityProviderConfig": {
                return Optional.ofNullable(clazz.cast(this.identityProviderConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", CLUSTER_NAME_FIELD);
        map.put("identityProviderConfig", IDENTITY_PROVIDER_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeIdentityProviderConfigRequest, T> g) {
        return obj -> g.apply((DescribeIdentityProviderConfigRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EksRequest.BuilderImpl
    implements Builder {
        private String clusterName;
        private IdentityProviderConfig identityProviderConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeIdentityProviderConfigRequest model) {
            super(model);
            this.clusterName(model.clusterName);
            this.identityProviderConfig(model.identityProviderConfig);
        }

        public final String getClusterName() {
            return this.clusterName;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final IdentityProviderConfig.Builder getIdentityProviderConfig() {
            return this.identityProviderConfig != null ? this.identityProviderConfig.toBuilder() : null;
        }

        public final void setIdentityProviderConfig(IdentityProviderConfig.BuilderImpl identityProviderConfig) {
            this.identityProviderConfig = identityProviderConfig != null ? identityProviderConfig.build() : null;
        }

        @Override
        public final Builder identityProviderConfig(IdentityProviderConfig identityProviderConfig) {
            this.identityProviderConfig = identityProviderConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeIdentityProviderConfigRequest build() {
            return new DescribeIdentityProviderConfigRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends EksRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeIdentityProviderConfigRequest> {
        public Builder clusterName(String var1);

        public Builder identityProviderConfig(IdentityProviderConfig var1);

        default public Builder identityProviderConfig(Consumer<IdentityProviderConfig.Builder> identityProviderConfig) {
            return this.identityProviderConfig((IdentityProviderConfig)((IdentityProviderConfig.Builder)IdentityProviderConfig.builder().applyMutation(identityProviderConfig)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

