/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.eks.model.ConfigStatus;
import software.amazon.awssdk.services.eks.model.TagMapCopier;
import software.amazon.awssdk.services.eks.model._requiredClaimsMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OidcIdentityProviderConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OidcIdentityProviderConfig> {
    private static final SdkField<String> IDENTITY_PROVIDER_CONFIG_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("identityProviderConfigName").getter(OidcIdentityProviderConfig.getter(OidcIdentityProviderConfig::identityProviderConfigName)).setter(OidcIdentityProviderConfig.setter(Builder::identityProviderConfigName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identityProviderConfigName").build()}).build();
    private static final SdkField<String> IDENTITY_PROVIDER_CONFIG_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("identityProviderConfigArn").getter(OidcIdentityProviderConfig.getter(OidcIdentityProviderConfig::identityProviderConfigArn)).setter(OidcIdentityProviderConfig.setter(Builder::identityProviderConfigArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identityProviderConfigArn").build()}).build();
    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clusterName").getter(OidcIdentityProviderConfig.getter(OidcIdentityProviderConfig::clusterName)).setter(OidcIdentityProviderConfig.setter(Builder::clusterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterName").build()}).build();
    private static final SdkField<String> ISSUER_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("issuerUrl").getter(OidcIdentityProviderConfig.getter(OidcIdentityProviderConfig::issuerUrl)).setter(OidcIdentityProviderConfig.setter(Builder::issuerUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("issuerUrl").build()}).build();
    private static final SdkField<String> CLIENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientId").getter(OidcIdentityProviderConfig.getter(OidcIdentityProviderConfig::clientId)).setter(OidcIdentityProviderConfig.setter(Builder::clientId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientId").build()}).build();
    private static final SdkField<String> USERNAME_CLAIM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("usernameClaim").getter(OidcIdentityProviderConfig.getter(OidcIdentityProviderConfig::usernameClaim)).setter(OidcIdentityProviderConfig.setter(Builder::usernameClaim)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usernameClaim").build()}).build();
    private static final SdkField<String> USERNAME_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("usernamePrefix").getter(OidcIdentityProviderConfig.getter(OidcIdentityProviderConfig::usernamePrefix)).setter(OidcIdentityProviderConfig.setter(Builder::usernamePrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usernamePrefix").build()}).build();
    private static final SdkField<String> GROUPS_CLAIM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("groupsClaim").getter(OidcIdentityProviderConfig.getter(OidcIdentityProviderConfig::groupsClaim)).setter(OidcIdentityProviderConfig.setter(Builder::groupsClaim)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupsClaim").build()}).build();
    private static final SdkField<String> GROUPS_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("groupsPrefix").getter(OidcIdentityProviderConfig.getter(OidcIdentityProviderConfig::groupsPrefix)).setter(OidcIdentityProviderConfig.setter(Builder::groupsPrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupsPrefix").build()}).build();
    private static final SdkField<Map<String, String>> REQUIRED_CLAIMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("requiredClaims").getter(OidcIdentityProviderConfig.getter(OidcIdentityProviderConfig::requiredClaims)).setter(OidcIdentityProviderConfig.setter(Builder::requiredClaims)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requiredClaims").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(OidcIdentityProviderConfig.getter(OidcIdentityProviderConfig::tags)).setter(OidcIdentityProviderConfig.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(OidcIdentityProviderConfig.getter(OidcIdentityProviderConfig::statusAsString)).setter(OidcIdentityProviderConfig.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTITY_PROVIDER_CONFIG_NAME_FIELD, IDENTITY_PROVIDER_CONFIG_ARN_FIELD, CLUSTER_NAME_FIELD, ISSUER_URL_FIELD, CLIENT_ID_FIELD, USERNAME_CLAIM_FIELD, USERNAME_PREFIX_FIELD, GROUPS_CLAIM_FIELD, GROUPS_PREFIX_FIELD, REQUIRED_CLAIMS_FIELD, TAGS_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("identityProviderConfigName", IDENTITY_PROVIDER_CONFIG_NAME_FIELD);
            this.put("identityProviderConfigArn", IDENTITY_PROVIDER_CONFIG_ARN_FIELD);
            this.put("clusterName", CLUSTER_NAME_FIELD);
            this.put("issuerUrl", ISSUER_URL_FIELD);
            this.put("clientId", CLIENT_ID_FIELD);
            this.put("usernameClaim", USERNAME_CLAIM_FIELD);
            this.put("usernamePrefix", USERNAME_PREFIX_FIELD);
            this.put("groupsClaim", GROUPS_CLAIM_FIELD);
            this.put("groupsPrefix", GROUPS_PREFIX_FIELD);
            this.put("requiredClaims", REQUIRED_CLAIMS_FIELD);
            this.put("tags", TAGS_FIELD);
            this.put("status", STATUS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String identityProviderConfigName;
    private final String identityProviderConfigArn;
    private final String clusterName;
    private final String issuerUrl;
    private final String clientId;
    private final String usernameClaim;
    private final String usernamePrefix;
    private final String groupsClaim;
    private final String groupsPrefix;
    private final Map<String, String> requiredClaims;
    private final Map<String, String> tags;
    private final String status;

    private OidcIdentityProviderConfig(BuilderImpl builder) {
        this.identityProviderConfigName = builder.identityProviderConfigName;
        this.identityProviderConfigArn = builder.identityProviderConfigArn;
        this.clusterName = builder.clusterName;
        this.issuerUrl = builder.issuerUrl;
        this.clientId = builder.clientId;
        this.usernameClaim = builder.usernameClaim;
        this.usernamePrefix = builder.usernamePrefix;
        this.groupsClaim = builder.groupsClaim;
        this.groupsPrefix = builder.groupsPrefix;
        this.requiredClaims = builder.requiredClaims;
        this.tags = builder.tags;
        this.status = builder.status;
    }

    public final String identityProviderConfigName() {
        return this.identityProviderConfigName;
    }

    public final String identityProviderConfigArn() {
        return this.identityProviderConfigArn;
    }

    public final String clusterName() {
        return this.clusterName;
    }

    public final String issuerUrl() {
        return this.issuerUrl;
    }

    public final String clientId() {
        return this.clientId;
    }

    public final String usernameClaim() {
        return this.usernameClaim;
    }

    public final String usernamePrefix() {
        return this.usernamePrefix;
    }

    public final String groupsClaim() {
        return this.groupsClaim;
    }

    public final String groupsPrefix() {
        return this.groupsPrefix;
    }

    public final boolean hasRequiredClaims() {
        return this.requiredClaims != null && !(this.requiredClaims instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> requiredClaims() {
        return this.requiredClaims;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final ConfigStatus status() {
        return ConfigStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.identityProviderConfigName());
        hashCode = 31 * hashCode + Objects.hashCode(this.identityProviderConfigArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.issuerUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientId());
        hashCode = 31 * hashCode + Objects.hashCode(this.usernameClaim());
        hashCode = 31 * hashCode + Objects.hashCode(this.usernamePrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupsClaim());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupsPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRequiredClaims() ? this.requiredClaims() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OidcIdentityProviderConfig)) {
            return false;
        }
        OidcIdentityProviderConfig other = (OidcIdentityProviderConfig)obj;
        return Objects.equals(this.identityProviderConfigName(), other.identityProviderConfigName()) && Objects.equals(this.identityProviderConfigArn(), other.identityProviderConfigArn()) && Objects.equals(this.clusterName(), other.clusterName()) && Objects.equals(this.issuerUrl(), other.issuerUrl()) && Objects.equals(this.clientId(), other.clientId()) && Objects.equals(this.usernameClaim(), other.usernameClaim()) && Objects.equals(this.usernamePrefix(), other.usernamePrefix()) && Objects.equals(this.groupsClaim(), other.groupsClaim()) && Objects.equals(this.groupsPrefix(), other.groupsPrefix()) && this.hasRequiredClaims() == other.hasRequiredClaims() && Objects.equals(this.requiredClaims(), other.requiredClaims()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"OidcIdentityProviderConfig").add("IdentityProviderConfigName", (Object)this.identityProviderConfigName()).add("IdentityProviderConfigArn", (Object)this.identityProviderConfigArn()).add("ClusterName", (Object)this.clusterName()).add("IssuerUrl", (Object)this.issuerUrl()).add("ClientId", (Object)this.clientId()).add("UsernameClaim", (Object)this.usernameClaim()).add("UsernamePrefix", (Object)this.usernamePrefix()).add("GroupsClaim", (Object)this.groupsClaim()).add("GroupsPrefix", (Object)this.groupsPrefix()).add("RequiredClaims", this.hasRequiredClaims() ? this.requiredClaims() : null).add("Tags", this.hasTags() ? this.tags() : null).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "identityProviderConfigName": {
                return Optional.ofNullable(clazz.cast(this.identityProviderConfigName()));
            }
            case "identityProviderConfigArn": {
                return Optional.ofNullable(clazz.cast(this.identityProviderConfigArn()));
            }
            case "clusterName": {
                return Optional.ofNullable(clazz.cast(this.clusterName()));
            }
            case "issuerUrl": {
                return Optional.ofNullable(clazz.cast(this.issuerUrl()));
            }
            case "clientId": {
                return Optional.ofNullable(clazz.cast(this.clientId()));
            }
            case "usernameClaim": {
                return Optional.ofNullable(clazz.cast(this.usernameClaim()));
            }
            case "usernamePrefix": {
                return Optional.ofNullable(clazz.cast(this.usernamePrefix()));
            }
            case "groupsClaim": {
                return Optional.ofNullable(clazz.cast(this.groupsClaim()));
            }
            case "groupsPrefix": {
                return Optional.ofNullable(clazz.cast(this.groupsPrefix()));
            }
            case "requiredClaims": {
                return Optional.ofNullable(clazz.cast(this.requiredClaims()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<OidcIdentityProviderConfig, T> g) {
        return obj -> g.apply((OidcIdentityProviderConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String identityProviderConfigName;
        private String identityProviderConfigArn;
        private String clusterName;
        private String issuerUrl;
        private String clientId;
        private String usernameClaim;
        private String usernamePrefix;
        private String groupsClaim;
        private String groupsPrefix;
        private Map<String, String> requiredClaims = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(OidcIdentityProviderConfig model) {
            this.identityProviderConfigName(model.identityProviderConfigName);
            this.identityProviderConfigArn(model.identityProviderConfigArn);
            this.clusterName(model.clusterName);
            this.issuerUrl(model.issuerUrl);
            this.clientId(model.clientId);
            this.usernameClaim(model.usernameClaim);
            this.usernamePrefix(model.usernamePrefix);
            this.groupsClaim(model.groupsClaim);
            this.groupsPrefix(model.groupsPrefix);
            this.requiredClaims(model.requiredClaims);
            this.tags(model.tags);
            this.status(model.status);
        }

        public final String getIdentityProviderConfigName() {
            return this.identityProviderConfigName;
        }

        public final void setIdentityProviderConfigName(String identityProviderConfigName) {
            this.identityProviderConfigName = identityProviderConfigName;
        }

        @Override
        public final Builder identityProviderConfigName(String identityProviderConfigName) {
            this.identityProviderConfigName = identityProviderConfigName;
            return this;
        }

        public final String getIdentityProviderConfigArn() {
            return this.identityProviderConfigArn;
        }

        public final void setIdentityProviderConfigArn(String identityProviderConfigArn) {
            this.identityProviderConfigArn = identityProviderConfigArn;
        }

        @Override
        public final Builder identityProviderConfigArn(String identityProviderConfigArn) {
            this.identityProviderConfigArn = identityProviderConfigArn;
            return this;
        }

        public final String getClusterName() {
            return this.clusterName;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final String getIssuerUrl() {
            return this.issuerUrl;
        }

        public final void setIssuerUrl(String issuerUrl) {
            this.issuerUrl = issuerUrl;
        }

        @Override
        public final Builder issuerUrl(String issuerUrl) {
            this.issuerUrl = issuerUrl;
            return this;
        }

        public final String getClientId() {
            return this.clientId;
        }

        public final void setClientId(String clientId) {
            this.clientId = clientId;
        }

        @Override
        public final Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public final String getUsernameClaim() {
            return this.usernameClaim;
        }

        public final void setUsernameClaim(String usernameClaim) {
            this.usernameClaim = usernameClaim;
        }

        @Override
        public final Builder usernameClaim(String usernameClaim) {
            this.usernameClaim = usernameClaim;
            return this;
        }

        public final String getUsernamePrefix() {
            return this.usernamePrefix;
        }

        public final void setUsernamePrefix(String usernamePrefix) {
            this.usernamePrefix = usernamePrefix;
        }

        @Override
        public final Builder usernamePrefix(String usernamePrefix) {
            this.usernamePrefix = usernamePrefix;
            return this;
        }

        public final String getGroupsClaim() {
            return this.groupsClaim;
        }

        public final void setGroupsClaim(String groupsClaim) {
            this.groupsClaim = groupsClaim;
        }

        @Override
        public final Builder groupsClaim(String groupsClaim) {
            this.groupsClaim = groupsClaim;
            return this;
        }

        public final String getGroupsPrefix() {
            return this.groupsPrefix;
        }

        public final void setGroupsPrefix(String groupsPrefix) {
            this.groupsPrefix = groupsPrefix;
        }

        @Override
        public final Builder groupsPrefix(String groupsPrefix) {
            this.groupsPrefix = groupsPrefix;
            return this;
        }

        public final Map<String, String> getRequiredClaims() {
            if (this.requiredClaims instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.requiredClaims;
        }

        public final void setRequiredClaims(Map<String, String> requiredClaims) {
            this.requiredClaims = _requiredClaimsMapCopier.copy(requiredClaims);
        }

        @Override
        public final Builder requiredClaims(Map<String, String> requiredClaims) {
            this.requiredClaims = _requiredClaimsMapCopier.copy(requiredClaims);
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ConfigStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public OidcIdentityProviderConfig build() {
            return new OidcIdentityProviderConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OidcIdentityProviderConfig> {
        public Builder identityProviderConfigName(String var1);

        public Builder identityProviderConfigArn(String var1);

        public Builder clusterName(String var1);

        public Builder issuerUrl(String var1);

        public Builder clientId(String var1);

        public Builder usernameClaim(String var1);

        public Builder usernamePrefix(String var1);

        public Builder groupsClaim(String var1);

        public Builder groupsPrefix(String var1);

        public Builder requiredClaims(Map<String, String> var1);

        public Builder tags(Map<String, String> var1);

        public Builder status(String var1);

        public Builder status(ConfigStatus var1);
    }
}

