/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.eks.EksClient;
import software.amazon.awssdk.services.eks.model.AssociateEncryptionConfigRequest;
import software.amazon.awssdk.services.eks.model.AssociateEncryptionConfigResponse;
import software.amazon.awssdk.services.eks.model.AssociateIdentityProviderConfigRequest;
import software.amazon.awssdk.services.eks.model.AssociateIdentityProviderConfigResponse;
import software.amazon.awssdk.services.eks.model.BadRequestException;
import software.amazon.awssdk.services.eks.model.ClientException;
import software.amazon.awssdk.services.eks.model.CreateAddonRequest;
import software.amazon.awssdk.services.eks.model.CreateAddonResponse;
import software.amazon.awssdk.services.eks.model.CreateClusterRequest;
import software.amazon.awssdk.services.eks.model.CreateClusterResponse;
import software.amazon.awssdk.services.eks.model.CreateFargateProfileRequest;
import software.amazon.awssdk.services.eks.model.CreateFargateProfileResponse;
import software.amazon.awssdk.services.eks.model.CreateNodegroupRequest;
import software.amazon.awssdk.services.eks.model.CreateNodegroupResponse;
import software.amazon.awssdk.services.eks.model.DeleteAddonRequest;
import software.amazon.awssdk.services.eks.model.DeleteAddonResponse;
import software.amazon.awssdk.services.eks.model.DeleteClusterRequest;
import software.amazon.awssdk.services.eks.model.DeleteClusterResponse;
import software.amazon.awssdk.services.eks.model.DeleteFargateProfileRequest;
import software.amazon.awssdk.services.eks.model.DeleteFargateProfileResponse;
import software.amazon.awssdk.services.eks.model.DeleteNodegroupRequest;
import software.amazon.awssdk.services.eks.model.DeleteNodegroupResponse;
import software.amazon.awssdk.services.eks.model.DescribeAddonRequest;
import software.amazon.awssdk.services.eks.model.DescribeAddonResponse;
import software.amazon.awssdk.services.eks.model.DescribeAddonVersionsRequest;
import software.amazon.awssdk.services.eks.model.DescribeAddonVersionsResponse;
import software.amazon.awssdk.services.eks.model.DescribeClusterRequest;
import software.amazon.awssdk.services.eks.model.DescribeClusterResponse;
import software.amazon.awssdk.services.eks.model.DescribeFargateProfileRequest;
import software.amazon.awssdk.services.eks.model.DescribeFargateProfileResponse;
import software.amazon.awssdk.services.eks.model.DescribeIdentityProviderConfigRequest;
import software.amazon.awssdk.services.eks.model.DescribeIdentityProviderConfigResponse;
import software.amazon.awssdk.services.eks.model.DescribeNodegroupRequest;
import software.amazon.awssdk.services.eks.model.DescribeNodegroupResponse;
import software.amazon.awssdk.services.eks.model.DescribeUpdateRequest;
import software.amazon.awssdk.services.eks.model.DescribeUpdateResponse;
import software.amazon.awssdk.services.eks.model.DisassociateIdentityProviderConfigRequest;
import software.amazon.awssdk.services.eks.model.DisassociateIdentityProviderConfigResponse;
import software.amazon.awssdk.services.eks.model.EksException;
import software.amazon.awssdk.services.eks.model.EksRequest;
import software.amazon.awssdk.services.eks.model.InvalidParameterException;
import software.amazon.awssdk.services.eks.model.InvalidRequestException;
import software.amazon.awssdk.services.eks.model.ListAddonsRequest;
import software.amazon.awssdk.services.eks.model.ListAddonsResponse;
import software.amazon.awssdk.services.eks.model.ListClustersRequest;
import software.amazon.awssdk.services.eks.model.ListClustersResponse;
import software.amazon.awssdk.services.eks.model.ListFargateProfilesRequest;
import software.amazon.awssdk.services.eks.model.ListFargateProfilesResponse;
import software.amazon.awssdk.services.eks.model.ListIdentityProviderConfigsRequest;
import software.amazon.awssdk.services.eks.model.ListIdentityProviderConfigsResponse;
import software.amazon.awssdk.services.eks.model.ListNodegroupsRequest;
import software.amazon.awssdk.services.eks.model.ListNodegroupsResponse;
import software.amazon.awssdk.services.eks.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.eks.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.eks.model.ListUpdatesRequest;
import software.amazon.awssdk.services.eks.model.ListUpdatesResponse;
import software.amazon.awssdk.services.eks.model.NotFoundException;
import software.amazon.awssdk.services.eks.model.ResourceInUseException;
import software.amazon.awssdk.services.eks.model.ResourceLimitExceededException;
import software.amazon.awssdk.services.eks.model.ResourceNotFoundException;
import software.amazon.awssdk.services.eks.model.ServerException;
import software.amazon.awssdk.services.eks.model.ServiceUnavailableException;
import software.amazon.awssdk.services.eks.model.TagResourceRequest;
import software.amazon.awssdk.services.eks.model.TagResourceResponse;
import software.amazon.awssdk.services.eks.model.UnsupportedAvailabilityZoneException;
import software.amazon.awssdk.services.eks.model.UntagResourceRequest;
import software.amazon.awssdk.services.eks.model.UntagResourceResponse;
import software.amazon.awssdk.services.eks.model.UpdateAddonRequest;
import software.amazon.awssdk.services.eks.model.UpdateAddonResponse;
import software.amazon.awssdk.services.eks.model.UpdateClusterConfigRequest;
import software.amazon.awssdk.services.eks.model.UpdateClusterConfigResponse;
import software.amazon.awssdk.services.eks.model.UpdateClusterVersionRequest;
import software.amazon.awssdk.services.eks.model.UpdateClusterVersionResponse;
import software.amazon.awssdk.services.eks.model.UpdateNodegroupConfigRequest;
import software.amazon.awssdk.services.eks.model.UpdateNodegroupConfigResponse;
import software.amazon.awssdk.services.eks.model.UpdateNodegroupVersionRequest;
import software.amazon.awssdk.services.eks.model.UpdateNodegroupVersionResponse;
import software.amazon.awssdk.services.eks.paginators.DescribeAddonVersionsIterable;
import software.amazon.awssdk.services.eks.paginators.ListAddonsIterable;
import software.amazon.awssdk.services.eks.paginators.ListClustersIterable;
import software.amazon.awssdk.services.eks.paginators.ListFargateProfilesIterable;
import software.amazon.awssdk.services.eks.paginators.ListIdentityProviderConfigsIterable;
import software.amazon.awssdk.services.eks.paginators.ListNodegroupsIterable;
import software.amazon.awssdk.services.eks.paginators.ListUpdatesIterable;
import software.amazon.awssdk.services.eks.transform.AssociateEncryptionConfigRequestMarshaller;
import software.amazon.awssdk.services.eks.transform.AssociateIdentityProviderConfigRequestMarshaller;
import software.amazon.awssdk.services.eks.transform.CreateAddonRequestMarshaller;
import software.amazon.awssdk.services.eks.transform.CreateClusterRequestMarshaller;
import software.amazon.awssdk.services.eks.transform.CreateFargateProfileRequestMarshaller;
import software.amazon.awssdk.services.eks.transform.CreateNodegroupRequestMarshaller;
import software.amazon.awssdk.services.eks.transform.DeleteAddonRequestMarshaller;
import software.amazon.awssdk.services.eks.transform.DeleteClusterRequestMarshaller;
import software.amazon.awssdk.services.eks.transform.DeleteFargateProfileRequestMarshaller;
import software.amazon.awssdk.services.eks.transform.DeleteNodegroupRequestMarshaller;
import software.amazon.awssdk.services.eks.transform.DescribeAddonRequestMarshaller;
import software.amazon.awssdk.services.eks.transform.DescribeAddonVersionsRequestMarshaller;
import software.amazon.awssdk.services.eks.transform.DescribeClusterRequestMarshaller;
import software.amazon.awssdk.services.eks.transform.DescribeFargateProfileRequestMarshaller;
import software.amazon.awssdk.services.eks.transform.DescribeIdentityProviderConfigRequestMarshaller;
import software.amazon.awssdk.services.eks.transform.DescribeNodegroupRequestMarshaller;
import software.amazon.awssdk.services.eks.transform.DescribeUpdateRequestMarshaller;
import software.amazon.awssdk.services.eks.transform.DisassociateIdentityProviderConfigRequestMarshaller;
import software.amazon.awssdk.services.eks.transform.ListAddonsRequestMarshaller;
import software.amazon.awssdk.services.eks.transform.ListClustersRequestMarshaller;
import software.amazon.awssdk.services.eks.transform.ListFargateProfilesRequestMarshaller;
import software.amazon.awssdk.services.eks.transform.ListIdentityProviderConfigsRequestMarshaller;
import software.amazon.awssdk.services.eks.transform.ListNodegroupsRequestMarshaller;
import software.amazon.awssdk.services.eks.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.eks.transform.ListUpdatesRequestMarshaller;
import software.amazon.awssdk.services.eks.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.eks.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.eks.transform.UpdateAddonRequestMarshaller;
import software.amazon.awssdk.services.eks.transform.UpdateClusterConfigRequestMarshaller;
import software.amazon.awssdk.services.eks.transform.UpdateClusterVersionRequestMarshaller;
import software.amazon.awssdk.services.eks.transform.UpdateNodegroupConfigRequestMarshaller;
import software.amazon.awssdk.services.eks.transform.UpdateNodegroupVersionRequestMarshaller;
import software.amazon.awssdk.services.eks.waiters.EksWaiter;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultEksClient
implements EksClient {
    private static final Logger log = Logger.loggerFor(DefaultEksClient.class);
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultEksClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "eks";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AssociateEncryptionConfigResponse associateEncryptionConfig(AssociateEncryptionConfigRequest associateEncryptionConfigRequest) throws InvalidParameterException, ClientException, ServerException, ResourceInUseException, ResourceNotFoundException, InvalidRequestException, AwsServiceException, SdkClientException, EksException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AssociateEncryptionConfigResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultEksClient.resolveMetricPublishers(this.clientConfiguration, associateEncryptionConfigRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"EKS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AssociateEncryptionConfig");
            AssociateEncryptionConfigResponse associateEncryptionConfigResponse = (AssociateEncryptionConfigResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssociateEncryptionConfig").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)associateEncryptionConfigRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AssociateEncryptionConfigRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return associateEncryptionConfigResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEksClient.lambda$associateEncryptionConfig$0((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AssociateIdentityProviderConfigResponse associateIdentityProviderConfig(AssociateIdentityProviderConfigRequest associateIdentityProviderConfigRequest) throws InvalidParameterException, ClientException, ServerException, ResourceInUseException, ResourceNotFoundException, InvalidRequestException, AwsServiceException, SdkClientException, EksException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AssociateIdentityProviderConfigResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultEksClient.resolveMetricPublishers(this.clientConfiguration, associateIdentityProviderConfigRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"EKS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AssociateIdentityProviderConfig");
            AssociateIdentityProviderConfigResponse associateIdentityProviderConfigResponse = (AssociateIdentityProviderConfigResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssociateIdentityProviderConfig").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)associateIdentityProviderConfigRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AssociateIdentityProviderConfigRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return associateIdentityProviderConfigResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEksClient.lambda$associateIdentityProviderConfig$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateAddonResponse createAddon(CreateAddonRequest createAddonRequest) throws InvalidParameterException, InvalidRequestException, ResourceNotFoundException, ResourceInUseException, ClientException, ServerException, AwsServiceException, SdkClientException, EksException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateAddonResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultEksClient.resolveMetricPublishers(this.clientConfiguration, createAddonRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"EKS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateAddon");
            CreateAddonResponse createAddonResponse = (CreateAddonResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateAddon").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createAddonRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateAddonRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createAddonResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEksClient.lambda$createAddon$2((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateClusterResponse createCluster(CreateClusterRequest createClusterRequest) throws ResourceInUseException, ResourceLimitExceededException, InvalidParameterException, ClientException, ServerException, ServiceUnavailableException, UnsupportedAvailabilityZoneException, AwsServiceException, SdkClientException, EksException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateClusterResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultEksClient.resolveMetricPublishers(this.clientConfiguration, createClusterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"EKS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateCluster");
            CreateClusterResponse createClusterResponse = (CreateClusterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateCluster").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createClusterRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateClusterRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createClusterResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEksClient.lambda$createCluster$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateFargateProfileResponse createFargateProfile(CreateFargateProfileRequest createFargateProfileRequest) throws InvalidParameterException, InvalidRequestException, ClientException, ServerException, ResourceLimitExceededException, UnsupportedAvailabilityZoneException, AwsServiceException, SdkClientException, EksException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateFargateProfileResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultEksClient.resolveMetricPublishers(this.clientConfiguration, createFargateProfileRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"EKS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateFargateProfile");
            CreateFargateProfileResponse createFargateProfileResponse = (CreateFargateProfileResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateFargateProfile").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createFargateProfileRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateFargateProfileRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createFargateProfileResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEksClient.lambda$createFargateProfile$4((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateNodegroupResponse createNodegroup(CreateNodegroupRequest createNodegroupRequest) throws ResourceInUseException, ResourceLimitExceededException, InvalidRequestException, InvalidParameterException, ClientException, ServerException, ServiceUnavailableException, AwsServiceException, SdkClientException, EksException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateNodegroupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultEksClient.resolveMetricPublishers(this.clientConfiguration, createNodegroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"EKS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateNodegroup");
            CreateNodegroupResponse createNodegroupResponse = (CreateNodegroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateNodegroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createNodegroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateNodegroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createNodegroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEksClient.lambda$createNodegroup$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteAddonResponse deleteAddon(DeleteAddonRequest deleteAddonRequest) throws InvalidParameterException, InvalidRequestException, ResourceNotFoundException, ClientException, ServerException, AwsServiceException, SdkClientException, EksException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteAddonResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultEksClient.resolveMetricPublishers(this.clientConfiguration, deleteAddonRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"EKS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteAddon");
            DeleteAddonResponse deleteAddonResponse = (DeleteAddonResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteAddon").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteAddonRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteAddonRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteAddonResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEksClient.lambda$deleteAddon$6((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteClusterResponse deleteCluster(DeleteClusterRequest deleteClusterRequest) throws ResourceInUseException, ResourceNotFoundException, ClientException, ServerException, ServiceUnavailableException, AwsServiceException, SdkClientException, EksException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteClusterResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultEksClient.resolveMetricPublishers(this.clientConfiguration, deleteClusterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"EKS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteCluster");
            DeleteClusterResponse deleteClusterResponse = (DeleteClusterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteCluster").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteClusterRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteClusterRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteClusterResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEksClient.lambda$deleteCluster$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteFargateProfileResponse deleteFargateProfile(DeleteFargateProfileRequest deleteFargateProfileRequest) throws InvalidParameterException, ClientException, ServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, EksException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteFargateProfileResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultEksClient.resolveMetricPublishers(this.clientConfiguration, deleteFargateProfileRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"EKS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteFargateProfile");
            DeleteFargateProfileResponse deleteFargateProfileResponse = (DeleteFargateProfileResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteFargateProfile").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteFargateProfileRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteFargateProfileRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteFargateProfileResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEksClient.lambda$deleteFargateProfile$8((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteNodegroupResponse deleteNodegroup(DeleteNodegroupRequest deleteNodegroupRequest) throws ResourceInUseException, ResourceNotFoundException, InvalidParameterException, ClientException, ServerException, ServiceUnavailableException, AwsServiceException, SdkClientException, EksException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteNodegroupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultEksClient.resolveMetricPublishers(this.clientConfiguration, deleteNodegroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"EKS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteNodegroup");
            DeleteNodegroupResponse deleteNodegroupResponse = (DeleteNodegroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteNodegroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteNodegroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteNodegroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteNodegroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEksClient.lambda$deleteNodegroup$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeAddonResponse describeAddon(DescribeAddonRequest describeAddonRequest) throws InvalidParameterException, InvalidRequestException, ResourceNotFoundException, ClientException, ServerException, AwsServiceException, SdkClientException, EksException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeAddonResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultEksClient.resolveMetricPublishers(this.clientConfiguration, describeAddonRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"EKS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeAddon");
            DescribeAddonResponse describeAddonResponse = (DescribeAddonResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAddon").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeAddonRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeAddonRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeAddonResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEksClient.lambda$describeAddon$10((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeAddonVersionsResponse describeAddonVersions(DescribeAddonVersionsRequest describeAddonVersionsRequest) throws ServerException, ResourceNotFoundException, InvalidParameterException, AwsServiceException, SdkClientException, EksException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeAddonVersionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultEksClient.resolveMetricPublishers(this.clientConfiguration, describeAddonVersionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"EKS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeAddonVersions");
            DescribeAddonVersionsResponse describeAddonVersionsResponse = (DescribeAddonVersionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAddonVersions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeAddonVersionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeAddonVersionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeAddonVersionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEksClient.lambda$describeAddonVersions$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public DescribeAddonVersionsIterable describeAddonVersionsPaginator(DescribeAddonVersionsRequest describeAddonVersionsRequest) throws ServerException, ResourceNotFoundException, InvalidParameterException, AwsServiceException, SdkClientException, EksException {
        return new DescribeAddonVersionsIterable(this, this.applyPaginatorUserAgent(describeAddonVersionsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeClusterResponse describeCluster(DescribeClusterRequest describeClusterRequest) throws ResourceNotFoundException, ClientException, ServerException, ServiceUnavailableException, AwsServiceException, SdkClientException, EksException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeClusterResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultEksClient.resolveMetricPublishers(this.clientConfiguration, describeClusterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"EKS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeCluster");
            DescribeClusterResponse describeClusterResponse = (DescribeClusterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeCluster").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeClusterRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeClusterRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeClusterResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEksClient.lambda$describeCluster$12((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeFargateProfileResponse describeFargateProfile(DescribeFargateProfileRequest describeFargateProfileRequest) throws InvalidParameterException, ClientException, ServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, EksException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeFargateProfileResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultEksClient.resolveMetricPublishers(this.clientConfiguration, describeFargateProfileRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"EKS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeFargateProfile");
            DescribeFargateProfileResponse describeFargateProfileResponse = (DescribeFargateProfileResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeFargateProfile").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeFargateProfileRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeFargateProfileRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeFargateProfileResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEksClient.lambda$describeFargateProfile$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeIdentityProviderConfigResponse describeIdentityProviderConfig(DescribeIdentityProviderConfigRequest describeIdentityProviderConfigRequest) throws InvalidParameterException, ResourceNotFoundException, ClientException, ServerException, ServiceUnavailableException, AwsServiceException, SdkClientException, EksException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeIdentityProviderConfigResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultEksClient.resolveMetricPublishers(this.clientConfiguration, describeIdentityProviderConfigRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"EKS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeIdentityProviderConfig");
            DescribeIdentityProviderConfigResponse describeIdentityProviderConfigResponse = (DescribeIdentityProviderConfigResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeIdentityProviderConfig").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeIdentityProviderConfigRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeIdentityProviderConfigRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeIdentityProviderConfigResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEksClient.lambda$describeIdentityProviderConfig$14((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeNodegroupResponse describeNodegroup(DescribeNodegroupRequest describeNodegroupRequest) throws InvalidParameterException, ResourceNotFoundException, ClientException, ServerException, ServiceUnavailableException, AwsServiceException, SdkClientException, EksException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeNodegroupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultEksClient.resolveMetricPublishers(this.clientConfiguration, describeNodegroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"EKS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeNodegroup");
            DescribeNodegroupResponse describeNodegroupResponse = (DescribeNodegroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeNodegroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeNodegroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeNodegroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeNodegroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEksClient.lambda$describeNodegroup$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeUpdateResponse describeUpdate(DescribeUpdateRequest describeUpdateRequest) throws InvalidParameterException, ClientException, ServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, EksException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeUpdateResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultEksClient.resolveMetricPublishers(this.clientConfiguration, describeUpdateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"EKS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeUpdate");
            DescribeUpdateResponse describeUpdateResponse = (DescribeUpdateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeUpdate").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeUpdateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeUpdateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeUpdateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEksClient.lambda$describeUpdate$16((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisassociateIdentityProviderConfigResponse disassociateIdentityProviderConfig(DisassociateIdentityProviderConfigRequest disassociateIdentityProviderConfigRequest) throws InvalidParameterException, ClientException, ServerException, ResourceInUseException, ResourceNotFoundException, InvalidRequestException, AwsServiceException, SdkClientException, EksException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisassociateIdentityProviderConfigResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultEksClient.resolveMetricPublishers(this.clientConfiguration, disassociateIdentityProviderConfigRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"EKS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisassociateIdentityProviderConfig");
            DisassociateIdentityProviderConfigResponse disassociateIdentityProviderConfigResponse = (DisassociateIdentityProviderConfigResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisassociateIdentityProviderConfig").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)disassociateIdentityProviderConfigRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DisassociateIdentityProviderConfigRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return disassociateIdentityProviderConfigResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEksClient.lambda$disassociateIdentityProviderConfig$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListAddonsResponse listAddons(ListAddonsRequest listAddonsRequest) throws InvalidParameterException, InvalidRequestException, ClientException, ResourceNotFoundException, ServerException, AwsServiceException, SdkClientException, EksException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAddonsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultEksClient.resolveMetricPublishers(this.clientConfiguration, listAddonsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"EKS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListAddons");
            ListAddonsResponse listAddonsResponse = (ListAddonsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAddons").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listAddonsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListAddonsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listAddonsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEksClient.lambda$listAddons$18((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListAddonsIterable listAddonsPaginator(ListAddonsRequest listAddonsRequest) throws InvalidParameterException, InvalidRequestException, ClientException, ResourceNotFoundException, ServerException, AwsServiceException, SdkClientException, EksException {
        return new ListAddonsIterable(this, this.applyPaginatorUserAgent(listAddonsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListClustersResponse listClusters(ListClustersRequest listClustersRequest) throws InvalidParameterException, ClientException, ServerException, ServiceUnavailableException, AwsServiceException, SdkClientException, EksException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListClustersResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultEksClient.resolveMetricPublishers(this.clientConfiguration, listClustersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"EKS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListClusters");
            ListClustersResponse listClustersResponse = (ListClustersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListClusters").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listClustersRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListClustersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listClustersResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEksClient.lambda$listClusters$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListClustersIterable listClustersPaginator(ListClustersRequest listClustersRequest) throws InvalidParameterException, ClientException, ServerException, ServiceUnavailableException, AwsServiceException, SdkClientException, EksException {
        return new ListClustersIterable(this, this.applyPaginatorUserAgent(listClustersRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListFargateProfilesResponse listFargateProfiles(ListFargateProfilesRequest listFargateProfilesRequest) throws InvalidParameterException, ResourceNotFoundException, ClientException, ServerException, AwsServiceException, SdkClientException, EksException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListFargateProfilesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultEksClient.resolveMetricPublishers(this.clientConfiguration, listFargateProfilesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"EKS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListFargateProfiles");
            ListFargateProfilesResponse listFargateProfilesResponse = (ListFargateProfilesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListFargateProfiles").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listFargateProfilesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListFargateProfilesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listFargateProfilesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEksClient.lambda$listFargateProfiles$20((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListFargateProfilesIterable listFargateProfilesPaginator(ListFargateProfilesRequest listFargateProfilesRequest) throws InvalidParameterException, ResourceNotFoundException, ClientException, ServerException, AwsServiceException, SdkClientException, EksException {
        return new ListFargateProfilesIterable(this, this.applyPaginatorUserAgent(listFargateProfilesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListIdentityProviderConfigsResponse listIdentityProviderConfigs(ListIdentityProviderConfigsRequest listIdentityProviderConfigsRequest) throws InvalidParameterException, ClientException, ServerException, ServiceUnavailableException, ResourceNotFoundException, AwsServiceException, SdkClientException, EksException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListIdentityProviderConfigsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultEksClient.resolveMetricPublishers(this.clientConfiguration, listIdentityProviderConfigsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"EKS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListIdentityProviderConfigs");
            ListIdentityProviderConfigsResponse listIdentityProviderConfigsResponse = (ListIdentityProviderConfigsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListIdentityProviderConfigs").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listIdentityProviderConfigsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListIdentityProviderConfigsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listIdentityProviderConfigsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEksClient.lambda$listIdentityProviderConfigs$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListIdentityProviderConfigsIterable listIdentityProviderConfigsPaginator(ListIdentityProviderConfigsRequest listIdentityProviderConfigsRequest) throws InvalidParameterException, ClientException, ServerException, ServiceUnavailableException, ResourceNotFoundException, AwsServiceException, SdkClientException, EksException {
        return new ListIdentityProviderConfigsIterable(this, this.applyPaginatorUserAgent(listIdentityProviderConfigsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListNodegroupsResponse listNodegroups(ListNodegroupsRequest listNodegroupsRequest) throws InvalidParameterException, ClientException, ServerException, ServiceUnavailableException, ResourceNotFoundException, AwsServiceException, SdkClientException, EksException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListNodegroupsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultEksClient.resolveMetricPublishers(this.clientConfiguration, listNodegroupsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"EKS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListNodegroups");
            ListNodegroupsResponse listNodegroupsResponse = (ListNodegroupsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListNodegroups").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listNodegroupsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListNodegroupsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listNodegroupsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEksClient.lambda$listNodegroups$22((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListNodegroupsIterable listNodegroupsPaginator(ListNodegroupsRequest listNodegroupsRequest) throws InvalidParameterException, ClientException, ServerException, ServiceUnavailableException, ResourceNotFoundException, AwsServiceException, SdkClientException, EksException {
        return new ListNodegroupsIterable(this, this.applyPaginatorUserAgent(listNodegroupsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws BadRequestException, NotFoundException, AwsServiceException, SdkClientException, EksException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultEksClient.resolveMetricPublishers(this.clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"EKS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            ListTagsForResourceResponse listTagsForResourceResponse = (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTagsForResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsForResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEksClient.lambda$listTagsForResource$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListUpdatesResponse listUpdates(ListUpdatesRequest listUpdatesRequest) throws InvalidParameterException, ClientException, ServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, EksException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListUpdatesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultEksClient.resolveMetricPublishers(this.clientConfiguration, listUpdatesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"EKS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListUpdates");
            ListUpdatesResponse listUpdatesResponse = (ListUpdatesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListUpdates").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listUpdatesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListUpdatesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listUpdatesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEksClient.lambda$listUpdates$24((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListUpdatesIterable listUpdatesPaginator(ListUpdatesRequest listUpdatesRequest) throws InvalidParameterException, ClientException, ServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, EksException {
        return new ListUpdatesIterable(this, this.applyPaginatorUserAgent(listUpdatesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws BadRequestException, NotFoundException, AwsServiceException, SdkClientException, EksException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultEksClient.resolveMetricPublishers(this.clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"EKS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)tagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEksClient.lambda$tagResource$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws BadRequestException, NotFoundException, AwsServiceException, SdkClientException, EksException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultEksClient.resolveMetricPublishers(this.clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"EKS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)untagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEksClient.lambda$untagResource$26((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateAddonResponse updateAddon(UpdateAddonRequest updateAddonRequest) throws InvalidParameterException, InvalidRequestException, ResourceNotFoundException, ResourceInUseException, ClientException, ServerException, AwsServiceException, SdkClientException, EksException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateAddonResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultEksClient.resolveMetricPublishers(this.clientConfiguration, updateAddonRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"EKS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateAddon");
            UpdateAddonResponse updateAddonResponse = (UpdateAddonResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateAddon").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateAddonRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateAddonRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateAddonResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEksClient.lambda$updateAddon$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateClusterConfigResponse updateClusterConfig(UpdateClusterConfigRequest updateClusterConfigRequest) throws InvalidParameterException, ClientException, ServerException, ResourceInUseException, ResourceNotFoundException, InvalidRequestException, AwsServiceException, SdkClientException, EksException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateClusterConfigResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultEksClient.resolveMetricPublishers(this.clientConfiguration, updateClusterConfigRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"EKS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateClusterConfig");
            UpdateClusterConfigResponse updateClusterConfigResponse = (UpdateClusterConfigResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateClusterConfig").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateClusterConfigRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateClusterConfigRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateClusterConfigResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEksClient.lambda$updateClusterConfig$28((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateClusterVersionResponse updateClusterVersion(UpdateClusterVersionRequest updateClusterVersionRequest) throws InvalidParameterException, ClientException, ServerException, ResourceInUseException, ResourceNotFoundException, InvalidRequestException, AwsServiceException, SdkClientException, EksException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateClusterVersionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultEksClient.resolveMetricPublishers(this.clientConfiguration, updateClusterVersionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"EKS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateClusterVersion");
            UpdateClusterVersionResponse updateClusterVersionResponse = (UpdateClusterVersionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateClusterVersion").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateClusterVersionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateClusterVersionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateClusterVersionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEksClient.lambda$updateClusterVersion$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateNodegroupConfigResponse updateNodegroupConfig(UpdateNodegroupConfigRequest updateNodegroupConfigRequest) throws InvalidParameterException, ClientException, ServerException, ResourceInUseException, ResourceNotFoundException, InvalidRequestException, AwsServiceException, SdkClientException, EksException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateNodegroupConfigResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultEksClient.resolveMetricPublishers(this.clientConfiguration, updateNodegroupConfigRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"EKS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateNodegroupConfig");
            UpdateNodegroupConfigResponse updateNodegroupConfigResponse = (UpdateNodegroupConfigResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateNodegroupConfig").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateNodegroupConfigRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateNodegroupConfigRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateNodegroupConfigResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEksClient.lambda$updateNodegroupConfig$30((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateNodegroupVersionResponse updateNodegroupVersion(UpdateNodegroupVersionRequest updateNodegroupVersionRequest) throws InvalidParameterException, ClientException, ServerException, ResourceInUseException, ResourceNotFoundException, InvalidRequestException, AwsServiceException, SdkClientException, EksException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateNodegroupVersionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultEksClient.resolveMetricPublishers(this.clientConfiguration, updateNodegroupVersionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"EKS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateNodegroupVersion");
            UpdateNodegroupVersionResponse updateNodegroupVersionResponse = (UpdateNodegroupVersionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateNodegroupVersion").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateNodegroupVersionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateNodegroupVersionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateNodegroupVersionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEksClient.lambda$updateNodegroupVersion$31((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(EksException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("InvalidParameterException").exceptionBuilderSupplier(InvalidParameterException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceInUseException").exceptionBuilderSupplier(ResourceInUseException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidRequestException").exceptionBuilderSupplier(InvalidRequestException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NotFoundException").exceptionBuilderSupplier(NotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("UnsupportedAvailabilityZoneException").exceptionBuilderSupplier(UnsupportedAvailabilityZoneException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ServerException").exceptionBuilderSupplier(ServerException::builder).httpStatusCode(Integer.valueOf(500)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ClientException").exceptionBuilderSupplier(ClientException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").exceptionBuilderSupplier(ServiceUnavailableException::builder).httpStatusCode(Integer.valueOf(503)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").exceptionBuilderSupplier(ResourceLimitExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("BadRequestException").exceptionBuilderSupplier(BadRequestException::builder).httpStatusCode(Integer.valueOf(400)).build());
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends EksRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.17.30").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((EksRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    @Override
    public EksWaiter waiter() {
        return EksWaiter.builder().client(this).build();
    }

    private static /* synthetic */ void lambda$updateNodegroupVersion$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateNodegroupConfig$30(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateClusterVersion$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateClusterConfig$28(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateAddon$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$26(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listUpdates$24(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listNodegroups$22(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listIdentityProviderConfigs$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listFargateProfiles$20(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listClusters$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listAddons$18(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$disassociateIdentityProviderConfig$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeUpdate$16(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeNodegroup$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeIdentityProviderConfig$14(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeFargateProfile$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeCluster$12(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeAddonVersions$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeAddon$10(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteNodegroup$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteFargateProfile$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteCluster$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteAddon$6(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createNodegroup$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createFargateProfile$4(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createCluster$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createAddon$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$associateIdentityProviderConfig$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$associateEncryptionConfig$0(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

