/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.eks.model.EksRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeFargateProfileRequest
extends EksRequest
implements ToCopyableBuilder<Builder, DescribeFargateProfileRequest> {
    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clusterName").getter(DescribeFargateProfileRequest.getter(DescribeFargateProfileRequest::clusterName)).setter(DescribeFargateProfileRequest.setter(Builder::clusterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("name").build()}).build();
    private static final SdkField<String> FARGATE_PROFILE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("fargateProfileName").getter(DescribeFargateProfileRequest.getter(DescribeFargateProfileRequest::fargateProfileName)).setter(DescribeFargateProfileRequest.setter(Builder::fargateProfileName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("fargateProfileName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_NAME_FIELD, FARGATE_PROFILE_NAME_FIELD));
    private final String clusterName;
    private final String fargateProfileName;

    private DescribeFargateProfileRequest(BuilderImpl builder) {
        super(builder);
        this.clusterName = builder.clusterName;
        this.fargateProfileName = builder.fargateProfileName;
    }

    public String clusterName() {
        return this.clusterName;
    }

    public String fargateProfileName() {
        return this.fargateProfileName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.fargateProfileName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFargateProfileRequest)) {
            return false;
        }
        DescribeFargateProfileRequest other = (DescribeFargateProfileRequest)((Object)obj);
        return Objects.equals(this.clusterName(), other.clusterName()) && Objects.equals(this.fargateProfileName(), other.fargateProfileName());
    }

    public String toString() {
        return ToString.builder((String)"DescribeFargateProfileRequest").add("ClusterName", (Object)this.clusterName()).add("FargateProfileName", (Object)this.fargateProfileName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clusterName": {
                return Optional.ofNullable(clazz.cast(this.clusterName()));
            }
            case "fargateProfileName": {
                return Optional.ofNullable(clazz.cast(this.fargateProfileName()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeFargateProfileRequest, T> g) {
        return obj -> g.apply((DescribeFargateProfileRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EksRequest.BuilderImpl
    implements Builder {
        private String clusterName;
        private String fargateProfileName;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFargateProfileRequest model) {
            super(model);
            this.clusterName(model.clusterName);
            this.fargateProfileName(model.fargateProfileName);
        }

        public final String getClusterName() {
            return this.clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        public final String getFargateProfileName() {
            return this.fargateProfileName;
        }

        @Override
        public final Builder fargateProfileName(String fargateProfileName) {
            this.fargateProfileName = fargateProfileName;
            return this;
        }

        public final void setFargateProfileName(String fargateProfileName) {
            this.fargateProfileName = fargateProfileName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeFargateProfileRequest build() {
            return new DescribeFargateProfileRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EksRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeFargateProfileRequest> {
        public Builder clusterName(String var1);

        public Builder fargateProfileName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

