/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.eks.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VpcConfigRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VpcConfigRequest> {
    private static final SdkField<List<String>> SUBNET_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(VpcConfigRequest.getter(VpcConfigRequest::subnetIds)).setter(VpcConfigRequest.setter(Builder::subnetIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subnetIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(VpcConfigRequest.getter(VpcConfigRequest::securityGroupIds)).setter(VpcConfigRequest.setter(Builder::securityGroupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityGroupIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> ENDPOINT_PUBLIC_ACCESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(VpcConfigRequest.getter(VpcConfigRequest::endpointPublicAccess)).setter(VpcConfigRequest.setter(Builder::endpointPublicAccess)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpointPublicAccess").build()}).build();
    private static final SdkField<Boolean> ENDPOINT_PRIVATE_ACCESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(VpcConfigRequest.getter(VpcConfigRequest::endpointPrivateAccess)).setter(VpcConfigRequest.setter(Builder::endpointPrivateAccess)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpointPrivateAccess").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBNET_IDS_FIELD, SECURITY_GROUP_IDS_FIELD, ENDPOINT_PUBLIC_ACCESS_FIELD, ENDPOINT_PRIVATE_ACCESS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> subnetIds;
    private final List<String> securityGroupIds;
    private final Boolean endpointPublicAccess;
    private final Boolean endpointPrivateAccess;

    private VpcConfigRequest(BuilderImpl builder) {
        this.subnetIds = builder.subnetIds;
        this.securityGroupIds = builder.securityGroupIds;
        this.endpointPublicAccess = builder.endpointPublicAccess;
        this.endpointPrivateAccess = builder.endpointPrivateAccess;
    }

    public boolean hasSubnetIds() {
        return this.subnetIds != null && !(this.subnetIds instanceof SdkAutoConstructList);
    }

    public List<String> subnetIds() {
        return this.subnetIds;
    }

    public boolean hasSecurityGroupIds() {
        return this.securityGroupIds != null && !(this.securityGroupIds instanceof SdkAutoConstructList);
    }

    public List<String> securityGroupIds() {
        return this.securityGroupIds;
    }

    public Boolean endpointPublicAccess() {
        return this.endpointPublicAccess;
    }

    public Boolean endpointPrivateAccess() {
        return this.endpointPrivateAccess;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityGroupIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointPublicAccess());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointPrivateAccess());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpcConfigRequest)) {
            return false;
        }
        VpcConfigRequest other = (VpcConfigRequest)obj;
        return Objects.equals(this.subnetIds(), other.subnetIds()) && Objects.equals(this.securityGroupIds(), other.securityGroupIds()) && Objects.equals(this.endpointPublicAccess(), other.endpointPublicAccess()) && Objects.equals(this.endpointPrivateAccess(), other.endpointPrivateAccess());
    }

    public String toString() {
        return ToString.builder((String)"VpcConfigRequest").add("SubnetIds", this.subnetIds()).add("SecurityGroupIds", this.securityGroupIds()).add("EndpointPublicAccess", (Object)this.endpointPublicAccess()).add("EndpointPrivateAccess", (Object)this.endpointPrivateAccess()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "subnetIds": {
                return Optional.ofNullable(clazz.cast(this.subnetIds()));
            }
            case "securityGroupIds": {
                return Optional.ofNullable(clazz.cast(this.securityGroupIds()));
            }
            case "endpointPublicAccess": {
                return Optional.ofNullable(clazz.cast(this.endpointPublicAccess()));
            }
            case "endpointPrivateAccess": {
                return Optional.ofNullable(clazz.cast(this.endpointPrivateAccess()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VpcConfigRequest, T> g) {
        return obj -> g.apply((VpcConfigRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();
        private Boolean endpointPublicAccess;
        private Boolean endpointPrivateAccess;

        private BuilderImpl() {
        }

        private BuilderImpl(VpcConfigRequest model) {
            this.subnetIds(model.subnetIds);
            this.securityGroupIds(model.securityGroupIds);
            this.endpointPublicAccess(model.endpointPublicAccess);
            this.endpointPrivateAccess(model.endpointPrivateAccess);
        }

        public final Collection<String> getSubnetIds() {
            return this.subnetIds;
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = StringListCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String ... subnetIds) {
            this.subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = StringListCopier.copy(subnetIds);
        }

        public final Collection<String> getSecurityGroupIds() {
            return this.securityGroupIds;
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = StringListCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String ... securityGroupIds) {
            this.securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = StringListCopier.copy(securityGroupIds);
        }

        public final Boolean getEndpointPublicAccess() {
            return this.endpointPublicAccess;
        }

        @Override
        public final Builder endpointPublicAccess(Boolean endpointPublicAccess) {
            this.endpointPublicAccess = endpointPublicAccess;
            return this;
        }

        public final void setEndpointPublicAccess(Boolean endpointPublicAccess) {
            this.endpointPublicAccess = endpointPublicAccess;
        }

        public final Boolean getEndpointPrivateAccess() {
            return this.endpointPrivateAccess;
        }

        @Override
        public final Builder endpointPrivateAccess(Boolean endpointPrivateAccess) {
            this.endpointPrivateAccess = endpointPrivateAccess;
            return this;
        }

        public final void setEndpointPrivateAccess(Boolean endpointPrivateAccess) {
            this.endpointPrivateAccess = endpointPrivateAccess;
        }

        public VpcConfigRequest build() {
            return new VpcConfigRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VpcConfigRequest> {
        public Builder subnetIds(Collection<String> var1);

        public Builder subnetIds(String ... var1);

        public Builder securityGroupIds(Collection<String> var1);

        public Builder securityGroupIds(String ... var1);

        public Builder endpointPublicAccess(Boolean var1);

        public Builder endpointPrivateAccess(Boolean var1);
    }
}

