/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.efs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.efs.model.EfsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeFileSystemsRequest
extends EfsRequest
implements ToCopyableBuilder<Builder, DescribeFileSystemsRequest> {
    private static final SdkField<Integer> MAX_ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxItems").getter(DescribeFileSystemsRequest.getter(DescribeFileSystemsRequest::maxItems)).setter(DescribeFileSystemsRequest.setter(Builder::maxItems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("MaxItems").build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(DescribeFileSystemsRequest.getter(DescribeFileSystemsRequest::marker)).setter(DescribeFileSystemsRequest.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("Marker").build()}).build();
    private static final SdkField<String> CREATION_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreationToken").getter(DescribeFileSystemsRequest.getter(DescribeFileSystemsRequest::creationToken)).setter(DescribeFileSystemsRequest.setter(Builder::creationToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("CreationToken").build()}).build();
    private static final SdkField<String> FILE_SYSTEM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FileSystemId").getter(DescribeFileSystemsRequest.getter(DescribeFileSystemsRequest::fileSystemId)).setter(DescribeFileSystemsRequest.setter(Builder::fileSystemId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("FileSystemId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_ITEMS_FIELD, MARKER_FIELD, CREATION_TOKEN_FIELD, FILE_SYSTEM_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeFileSystemsRequest.memberNameToFieldInitializer();
    private final Integer maxItems;
    private final String marker;
    private final String creationToken;
    private final String fileSystemId;

    private DescribeFileSystemsRequest(BuilderImpl builder) {
        super(builder);
        this.maxItems = builder.maxItems;
        this.marker = builder.marker;
        this.creationToken = builder.creationToken;
        this.fileSystemId = builder.fileSystemId;
    }

    public final Integer maxItems() {
        return this.maxItems;
    }

    public final String marker() {
        return this.marker;
    }

    public final String creationToken() {
        return this.creationToken;
    }

    public final String fileSystemId() {
        return this.fileSystemId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.maxItems());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileSystemId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFileSystemsRequest)) {
            return false;
        }
        DescribeFileSystemsRequest other = (DescribeFileSystemsRequest)((Object)obj);
        return Objects.equals(this.maxItems(), other.maxItems()) && Objects.equals(this.marker(), other.marker()) && Objects.equals(this.creationToken(), other.creationToken()) && Objects.equals(this.fileSystemId(), other.fileSystemId());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeFileSystemsRequest").add("MaxItems", (Object)this.maxItems()).add("Marker", (Object)this.marker()).add("CreationToken", (Object)this.creationToken()).add("FileSystemId", (Object)this.fileSystemId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MaxItems": {
                return Optional.ofNullable(clazz.cast(this.maxItems()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "CreationToken": {
                return Optional.ofNullable(clazz.cast(this.creationToken()));
            }
            case "FileSystemId": {
                return Optional.ofNullable(clazz.cast(this.fileSystemId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("MaxItems", MAX_ITEMS_FIELD);
        map.put("Marker", MARKER_FIELD);
        map.put("CreationToken", CREATION_TOKEN_FIELD);
        map.put("FileSystemId", FILE_SYSTEM_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeFileSystemsRequest, T> g) {
        return obj -> g.apply((DescribeFileSystemsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EfsRequest.BuilderImpl
    implements Builder {
        private Integer maxItems;
        private String marker;
        private String creationToken;
        private String fileSystemId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFileSystemsRequest model) {
            super(model);
            this.maxItems(model.maxItems);
            this.marker(model.marker);
            this.creationToken(model.creationToken);
            this.fileSystemId(model.fileSystemId);
        }

        public final Integer getMaxItems() {
            return this.maxItems;
        }

        public final void setMaxItems(Integer maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public final Builder maxItems(Integer maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final String getMarker() {
            return this.marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final String getCreationToken() {
            return this.creationToken;
        }

        public final void setCreationToken(String creationToken) {
            this.creationToken = creationToken;
        }

        @Override
        public final Builder creationToken(String creationToken) {
            this.creationToken = creationToken;
            return this;
        }

        public final String getFileSystemId() {
            return this.fileSystemId;
        }

        public final void setFileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
        }

        @Override
        public final Builder fileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeFileSystemsRequest build() {
            return new DescribeFileSystemsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends EfsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeFileSystemsRequest> {
        public Builder maxItems(Integer var1);

        public Builder marker(String var1);

        public Builder creationToken(String var1);

        public Builder fileSystemId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

