/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.efs;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.efs.DefaultEfsAsyncClient;
import software.amazon.awssdk.services.efs.DefaultEfsBaseClientBuilder;
import software.amazon.awssdk.services.efs.EfsAsyncClient;
import software.amazon.awssdk.services.efs.EfsAsyncClientBuilder;
import software.amazon.awssdk.services.efs.EfsServiceClientConfiguration;
import software.amazon.awssdk.services.efs.endpoints.EfsEndpointProvider;

@SdkInternalApi
final class DefaultEfsAsyncClientBuilder
extends DefaultEfsBaseClientBuilder<EfsAsyncClientBuilder, EfsAsyncClient>
implements EfsAsyncClientBuilder {
    DefaultEfsAsyncClientBuilder() {
    }

    @Override
    public DefaultEfsAsyncClientBuilder endpointProvider(EfsEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final EfsAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultEfsAsyncClientBuilder.validateClientOptions(clientConfiguration);
        EfsServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultEfsAsyncClient client = new DefaultEfsAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private EfsServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return EfsServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

