/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.efs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.efs.model.EfsResponse;
import software.amazon.awssdk.services.efs.model.LifecyclePoliciesCopier;
import software.amazon.awssdk.services.efs.model.LifecyclePolicy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutLifecycleConfigurationResponse
extends EfsResponse
implements ToCopyableBuilder<Builder, PutLifecycleConfigurationResponse> {
    private static final SdkField<List<LifecyclePolicy>> LIFECYCLE_POLICIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(PutLifecycleConfigurationResponse.getter(PutLifecycleConfigurationResponse::lifecyclePolicies)).setter(PutLifecycleConfigurationResponse.setter(Builder::lifecyclePolicies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LifecyclePolicies").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LifecyclePolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LIFECYCLE_POLICIES_FIELD));
    private final List<LifecyclePolicy> lifecyclePolicies;

    private PutLifecycleConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.lifecyclePolicies = builder.lifecyclePolicies;
    }

    public boolean hasLifecyclePolicies() {
        return this.lifecyclePolicies != null && !(this.lifecyclePolicies instanceof SdkAutoConstructList);
    }

    public List<LifecyclePolicy> lifecyclePolicies() {
        return this.lifecyclePolicies;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.lifecyclePolicies());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutLifecycleConfigurationResponse)) {
            return false;
        }
        PutLifecycleConfigurationResponse other = (PutLifecycleConfigurationResponse)((Object)obj);
        return Objects.equals(this.lifecyclePolicies(), other.lifecyclePolicies());
    }

    public String toString() {
        return ToString.builder((String)"PutLifecycleConfigurationResponse").add("LifecyclePolicies", this.lifecyclePolicies()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LifecyclePolicies": {
                return Optional.ofNullable(clazz.cast(this.lifecyclePolicies()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutLifecycleConfigurationResponse, T> g) {
        return obj -> g.apply((PutLifecycleConfigurationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EfsResponse.BuilderImpl
    implements Builder {
        private List<LifecyclePolicy> lifecyclePolicies = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutLifecycleConfigurationResponse model) {
            super(model);
            this.lifecyclePolicies(model.lifecyclePolicies);
        }

        public final Collection<LifecyclePolicy.Builder> getLifecyclePolicies() {
            return this.lifecyclePolicies != null ? (Collection)this.lifecyclePolicies.stream().map(LifecyclePolicy::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder lifecyclePolicies(Collection<LifecyclePolicy> lifecyclePolicies) {
            this.lifecyclePolicies = LifecyclePoliciesCopier.copy(lifecyclePolicies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lifecyclePolicies(LifecyclePolicy ... lifecyclePolicies) {
            this.lifecyclePolicies(Arrays.asList(lifecyclePolicies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lifecyclePolicies(Consumer<LifecyclePolicy.Builder> ... lifecyclePolicies) {
            this.lifecyclePolicies(Stream.of(lifecyclePolicies).map(c -> (LifecyclePolicy)((LifecyclePolicy.Builder)LifecyclePolicy.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLifecyclePolicies(Collection<LifecyclePolicy.BuilderImpl> lifecyclePolicies) {
            this.lifecyclePolicies = LifecyclePoliciesCopier.copyFromBuilder(lifecyclePolicies);
        }

        @Override
        public PutLifecycleConfigurationResponse build() {
            return new PutLifecycleConfigurationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EfsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutLifecycleConfigurationResponse> {
        public Builder lifecyclePolicies(Collection<LifecyclePolicy> var1);

        public Builder lifecyclePolicies(LifecyclePolicy ... var1);

        public Builder lifecyclePolicies(Consumer<LifecyclePolicy.Builder> ... var1);
    }
}

