/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.efs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.efs.model.LifeCycleState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MountTargetDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MountTargetDescription> {
    private static final SdkField<String> OWNER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MountTargetDescription.getter(MountTargetDescription::ownerId)).setter(MountTargetDescription.setter(Builder::ownerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId").build()}).build();
    private static final SdkField<String> MOUNT_TARGET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MountTargetDescription.getter(MountTargetDescription::mountTargetId)).setter(MountTargetDescription.setter(Builder::mountTargetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MountTargetId").build()}).build();
    private static final SdkField<String> FILE_SYSTEM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MountTargetDescription.getter(MountTargetDescription::fileSystemId)).setter(MountTargetDescription.setter(Builder::fileSystemId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSystemId").build()}).build();
    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MountTargetDescription.getter(MountTargetDescription::subnetId)).setter(MountTargetDescription.setter(Builder::subnetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId").build()}).build();
    private static final SdkField<String> LIFE_CYCLE_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MountTargetDescription.getter(MountTargetDescription::lifeCycleStateAsString)).setter(MountTargetDescription.setter(Builder::lifeCycleState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LifeCycleState").build()}).build();
    private static final SdkField<String> IP_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MountTargetDescription.getter(MountTargetDescription::ipAddress)).setter(MountTargetDescription.setter(Builder::ipAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpAddress").build()}).build();
    private static final SdkField<String> NETWORK_INTERFACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MountTargetDescription.getter(MountTargetDescription::networkInterfaceId)).setter(MountTargetDescription.setter(Builder::networkInterfaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceId").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MountTargetDescription.getter(MountTargetDescription::availabilityZoneId)).setter(MountTargetDescription.setter(Builder::availabilityZoneId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZoneId").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MountTargetDescription.getter(MountTargetDescription::availabilityZoneName)).setter(MountTargetDescription.setter(Builder::availabilityZoneName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZoneName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OWNER_ID_FIELD, MOUNT_TARGET_ID_FIELD, FILE_SYSTEM_ID_FIELD, SUBNET_ID_FIELD, LIFE_CYCLE_STATE_FIELD, IP_ADDRESS_FIELD, NETWORK_INTERFACE_ID_FIELD, AVAILABILITY_ZONE_ID_FIELD, AVAILABILITY_ZONE_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String ownerId;
    private final String mountTargetId;
    private final String fileSystemId;
    private final String subnetId;
    private final String lifeCycleState;
    private final String ipAddress;
    private final String networkInterfaceId;
    private final String availabilityZoneId;
    private final String availabilityZoneName;

    private MountTargetDescription(BuilderImpl builder) {
        this.ownerId = builder.ownerId;
        this.mountTargetId = builder.mountTargetId;
        this.fileSystemId = builder.fileSystemId;
        this.subnetId = builder.subnetId;
        this.lifeCycleState = builder.lifeCycleState;
        this.ipAddress = builder.ipAddress;
        this.networkInterfaceId = builder.networkInterfaceId;
        this.availabilityZoneId = builder.availabilityZoneId;
        this.availabilityZoneName = builder.availabilityZoneName;
    }

    public String ownerId() {
        return this.ownerId;
    }

    public String mountTargetId() {
        return this.mountTargetId;
    }

    public String fileSystemId() {
        return this.fileSystemId;
    }

    public String subnetId() {
        return this.subnetId;
    }

    public LifeCycleState lifeCycleState() {
        return LifeCycleState.fromValue(this.lifeCycleState);
    }

    public String lifeCycleStateAsString() {
        return this.lifeCycleState;
    }

    public String ipAddress() {
        return this.ipAddress;
    }

    public String networkInterfaceId() {
        return this.networkInterfaceId;
    }

    public String availabilityZoneId() {
        return this.availabilityZoneId;
    }

    public String availabilityZoneName() {
        return this.availabilityZoneName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.mountTargetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileSystemId());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.lifeCycleStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZoneName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MountTargetDescription)) {
            return false;
        }
        MountTargetDescription other = (MountTargetDescription)obj;
        return Objects.equals(this.ownerId(), other.ownerId()) && Objects.equals(this.mountTargetId(), other.mountTargetId()) && Objects.equals(this.fileSystemId(), other.fileSystemId()) && Objects.equals(this.subnetId(), other.subnetId()) && Objects.equals(this.lifeCycleStateAsString(), other.lifeCycleStateAsString()) && Objects.equals(this.ipAddress(), other.ipAddress()) && Objects.equals(this.networkInterfaceId(), other.networkInterfaceId()) && Objects.equals(this.availabilityZoneId(), other.availabilityZoneId()) && Objects.equals(this.availabilityZoneName(), other.availabilityZoneName());
    }

    public String toString() {
        return ToString.builder((String)"MountTargetDescription").add("OwnerId", (Object)this.ownerId()).add("MountTargetId", (Object)this.mountTargetId()).add("FileSystemId", (Object)this.fileSystemId()).add("SubnetId", (Object)this.subnetId()).add("LifeCycleState", (Object)this.lifeCycleStateAsString()).add("IpAddress", (Object)this.ipAddress()).add("NetworkInterfaceId", (Object)this.networkInterfaceId()).add("AvailabilityZoneId", (Object)this.availabilityZoneId()).add("AvailabilityZoneName", (Object)this.availabilityZoneName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OwnerId": {
                return Optional.ofNullable(clazz.cast(this.ownerId()));
            }
            case "MountTargetId": {
                return Optional.ofNullable(clazz.cast(this.mountTargetId()));
            }
            case "FileSystemId": {
                return Optional.ofNullable(clazz.cast(this.fileSystemId()));
            }
            case "SubnetId": {
                return Optional.ofNullable(clazz.cast(this.subnetId()));
            }
            case "LifeCycleState": {
                return Optional.ofNullable(clazz.cast(this.lifeCycleStateAsString()));
            }
            case "IpAddress": {
                return Optional.ofNullable(clazz.cast(this.ipAddress()));
            }
            case "NetworkInterfaceId": {
                return Optional.ofNullable(clazz.cast(this.networkInterfaceId()));
            }
            case "AvailabilityZoneId": {
                return Optional.ofNullable(clazz.cast(this.availabilityZoneId()));
            }
            case "AvailabilityZoneName": {
                return Optional.ofNullable(clazz.cast(this.availabilityZoneName()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MountTargetDescription, T> g) {
        return obj -> g.apply((MountTargetDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String ownerId;
        private String mountTargetId;
        private String fileSystemId;
        private String subnetId;
        private String lifeCycleState;
        private String ipAddress;
        private String networkInterfaceId;
        private String availabilityZoneId;
        private String availabilityZoneName;

        private BuilderImpl() {
        }

        private BuilderImpl(MountTargetDescription model) {
            this.ownerId(model.ownerId);
            this.mountTargetId(model.mountTargetId);
            this.fileSystemId(model.fileSystemId);
            this.subnetId(model.subnetId);
            this.lifeCycleState(model.lifeCycleState);
            this.ipAddress(model.ipAddress);
            this.networkInterfaceId(model.networkInterfaceId);
            this.availabilityZoneId(model.availabilityZoneId);
            this.availabilityZoneName(model.availabilityZoneName);
        }

        public final String getOwnerId() {
            return this.ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        public final String getMountTargetId() {
            return this.mountTargetId;
        }

        @Override
        public final Builder mountTargetId(String mountTargetId) {
            this.mountTargetId = mountTargetId;
            return this;
        }

        public final void setMountTargetId(String mountTargetId) {
            this.mountTargetId = mountTargetId;
        }

        public final String getFileSystemId() {
            return this.fileSystemId;
        }

        @Override
        public final Builder fileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
            return this;
        }

        public final void setFileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
        }

        public final String getSubnetId() {
            return this.subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        public final String getLifeCycleState() {
            return this.lifeCycleState;
        }

        @Override
        public final Builder lifeCycleState(String lifeCycleState) {
            this.lifeCycleState = lifeCycleState;
            return this;
        }

        @Override
        public final Builder lifeCycleState(LifeCycleState lifeCycleState) {
            this.lifeCycleState(lifeCycleState == null ? null : lifeCycleState.toString());
            return this;
        }

        public final void setLifeCycleState(String lifeCycleState) {
            this.lifeCycleState = lifeCycleState;
        }

        public final String getIpAddress() {
            return this.ipAddress;
        }

        @Override
        public final Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public final void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        public final String getNetworkInterfaceId() {
            return this.networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        public final String getAvailabilityZoneId() {
            return this.availabilityZoneId;
        }

        @Override
        public final Builder availabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
            return this;
        }

        public final void setAvailabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
        }

        public final String getAvailabilityZoneName() {
            return this.availabilityZoneName;
        }

        @Override
        public final Builder availabilityZoneName(String availabilityZoneName) {
            this.availabilityZoneName = availabilityZoneName;
            return this;
        }

        public final void setAvailabilityZoneName(String availabilityZoneName) {
            this.availabilityZoneName = availabilityZoneName;
        }

        public MountTargetDescription build() {
            return new MountTargetDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MountTargetDescription> {
        public Builder ownerId(String var1);

        public Builder mountTargetId(String var1);

        public Builder fileSystemId(String var1);

        public Builder subnetId(String var1);

        public Builder lifeCycleState(String var1);

        public Builder lifeCycleState(LifeCycleState var1);

        public Builder ipAddress(String var1);

        public Builder networkInterfaceId(String var1);

        public Builder availabilityZoneId(String var1);

        public Builder availabilityZoneName(String var1);
    }
}

