/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.efs.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.efs.model.FileSystemDescription;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class FileSystemDescriptionMarshaller {
    private static final MarshallingInfo<String> OWNERID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OwnerId").isBinary(false).build();
    private static final MarshallingInfo<String> CREATIONTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationToken").isBinary(false).build();
    private static final MarshallingInfo<String> FILESYSTEMID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FileSystemId").isBinary(false).build();
    private static final MarshallingInfo<Instant> CREATIONTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationTime").isBinary(false).build();
    private static final MarshallingInfo<String> LIFECYCLESTATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LifeCycleState").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<Integer> NUMBEROFMOUNTTARGETS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NumberOfMountTargets").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> SIZEINBYTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SizeInBytes").isBinary(false).build();
    private static final MarshallingInfo<String> PERFORMANCEMODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PerformanceMode").isBinary(false).build();
    private static final MarshallingInfo<Boolean> ENCRYPTED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Encrypted").isBinary(false).build();
    private static final MarshallingInfo<String> KMSKEYID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KmsKeyId").isBinary(false).build();
    private static final FileSystemDescriptionMarshaller INSTANCE = new FileSystemDescriptionMarshaller();

    private FileSystemDescriptionMarshaller() {
    }

    public static FileSystemDescriptionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(FileSystemDescription fileSystemDescription, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)fileSystemDescription, (String)"fileSystemDescription");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)fileSystemDescription.ownerId(), OWNERID_BINDING);
            protocolMarshaller.marshall((Object)fileSystemDescription.creationToken(), CREATIONTOKEN_BINDING);
            protocolMarshaller.marshall((Object)fileSystemDescription.fileSystemId(), FILESYSTEMID_BINDING);
            protocolMarshaller.marshall((Object)fileSystemDescription.creationTime(), CREATIONTIME_BINDING);
            protocolMarshaller.marshall((Object)fileSystemDescription.lifeCycleStateString(), LIFECYCLESTATE_BINDING);
            protocolMarshaller.marshall((Object)fileSystemDescription.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)fileSystemDescription.numberOfMountTargets(), NUMBEROFMOUNTTARGETS_BINDING);
            protocolMarshaller.marshall((Object)fileSystemDescription.sizeInBytes(), SIZEINBYTES_BINDING);
            protocolMarshaller.marshall((Object)fileSystemDescription.performanceModeString(), PERFORMANCEMODE_BINDING);
            protocolMarshaller.marshall((Object)fileSystemDescription.encrypted(), ENCRYPTED_BINDING);
            protocolMarshaller.marshall((Object)fileSystemDescription.kmsKeyId(), KMSKEYID_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

