/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.efs.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.efs.model.EFSRequest;
import software.amazon.awssdk.services.efs.model.PerformanceMode;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateFileSystemRequest
extends EFSRequest
implements ToCopyableBuilder<Builder, CreateFileSystemRequest> {
    private final String creationToken;
    private final String performanceMode;
    private final Boolean encrypted;
    private final String kmsKeyId;

    private CreateFileSystemRequest(BuilderImpl builder) {
        super(builder);
        this.creationToken = builder.creationToken;
        this.performanceMode = builder.performanceMode;
        this.encrypted = builder.encrypted;
        this.kmsKeyId = builder.kmsKeyId;
    }

    public String creationToken() {
        return this.creationToken;
    }

    public PerformanceMode performanceMode() {
        return PerformanceMode.fromValue(this.performanceMode);
    }

    public String performanceModeString() {
        return this.performanceMode;
    }

    public Boolean encrypted() {
        return this.encrypted;
    }

    public String kmsKeyId() {
        return this.kmsKeyId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.creationToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.performanceModeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.encrypted());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFileSystemRequest)) {
            return false;
        }
        CreateFileSystemRequest other = (CreateFileSystemRequest)((Object)obj);
        return Objects.equals(this.creationToken(), other.creationToken()) && Objects.equals(this.performanceModeString(), other.performanceModeString()) && Objects.equals(this.encrypted(), other.encrypted()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.creationToken() != null) {
            sb.append("CreationToken: ").append(this.creationToken()).append(",");
        }
        if (this.performanceModeString() != null) {
            sb.append("PerformanceMode: ").append(this.performanceModeString()).append(",");
        }
        if (this.encrypted() != null) {
            sb.append("Encrypted: ").append(this.encrypted()).append(",");
        }
        if (this.kmsKeyId() != null) {
            sb.append("KmsKeyId: ").append(this.kmsKeyId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CreationToken": {
                return Optional.of(clazz.cast(this.creationToken()));
            }
            case "PerformanceMode": {
                return Optional.of(clazz.cast(this.performanceModeString()));
            }
            case "Encrypted": {
                return Optional.of(clazz.cast(this.encrypted()));
            }
            case "KmsKeyId": {
                return Optional.of(clazz.cast(this.kmsKeyId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EFSRequest.BuilderImpl
    implements Builder {
        private String creationToken;
        private String performanceMode;
        private Boolean encrypted;
        private String kmsKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFileSystemRequest model) {
            this.creationToken(model.creationToken);
            this.performanceMode(model.performanceMode);
            this.encrypted(model.encrypted);
            this.kmsKeyId(model.kmsKeyId);
        }

        public final String getCreationToken() {
            return this.creationToken;
        }

        @Override
        public final Builder creationToken(String creationToken) {
            this.creationToken = creationToken;
            return this;
        }

        public final void setCreationToken(String creationToken) {
            this.creationToken = creationToken;
        }

        public final String getPerformanceMode() {
            return this.performanceMode;
        }

        @Override
        public final Builder performanceMode(String performanceMode) {
            this.performanceMode = performanceMode;
            return this;
        }

        @Override
        public final Builder performanceMode(PerformanceMode performanceMode) {
            this.performanceMode(performanceMode.toString());
            return this;
        }

        public final void setPerformanceMode(String performanceMode) {
            this.performanceMode = performanceMode;
        }

        public final Boolean getEncrypted() {
            return this.encrypted;
        }

        @Override
        public final Builder encrypted(Boolean encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        public final void setEncrypted(Boolean encrypted) {
            this.encrypted = encrypted;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateFileSystemRequest build() {
            return new CreateFileSystemRequest(this);
        }
    }

    public static interface Builder
    extends EFSRequest.Builder,
    CopyableBuilder<Builder, CreateFileSystemRequest> {
        public Builder creationToken(String var1);

        public Builder performanceMode(String var1);

        public Builder performanceMode(PerformanceMode var1);

        public Builder encrypted(Boolean var1);

        public Builder kmsKeyId(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

