/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.efs.model;

import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.efs.model.LifeCycleState;
import software.amazon.awssdk.services.efs.transform.MountTargetDescriptionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class MountTargetDescription
implements StructuredPojo,
ToCopyableBuilder<Builder, MountTargetDescription> {
    private final String ownerId;
    private final String mountTargetId;
    private final String fileSystemId;
    private final String subnetId;
    private final String lifeCycleState;
    private final String ipAddress;
    private final String networkInterfaceId;

    private MountTargetDescription(BuilderImpl builder) {
        this.ownerId = builder.ownerId;
        this.mountTargetId = builder.mountTargetId;
        this.fileSystemId = builder.fileSystemId;
        this.subnetId = builder.subnetId;
        this.lifeCycleState = builder.lifeCycleState;
        this.ipAddress = builder.ipAddress;
        this.networkInterfaceId = builder.networkInterfaceId;
    }

    public String ownerId() {
        return this.ownerId;
    }

    public String mountTargetId() {
        return this.mountTargetId;
    }

    public String fileSystemId() {
        return this.fileSystemId;
    }

    public String subnetId() {
        return this.subnetId;
    }

    public LifeCycleState lifeCycleState() {
        return LifeCycleState.fromValue(this.lifeCycleState);
    }

    public String lifeCycleStateString() {
        return this.lifeCycleState;
    }

    public String ipAddress() {
        return this.ipAddress;
    }

    public String networkInterfaceId() {
        return this.networkInterfaceId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.ownerId() == null ? 0 : this.ownerId().hashCode());
        hashCode = 31 * hashCode + (this.mountTargetId() == null ? 0 : this.mountTargetId().hashCode());
        hashCode = 31 * hashCode + (this.fileSystemId() == null ? 0 : this.fileSystemId().hashCode());
        hashCode = 31 * hashCode + (this.subnetId() == null ? 0 : this.subnetId().hashCode());
        hashCode = 31 * hashCode + (this.lifeCycleStateString() == null ? 0 : this.lifeCycleStateString().hashCode());
        hashCode = 31 * hashCode + (this.ipAddress() == null ? 0 : this.ipAddress().hashCode());
        hashCode = 31 * hashCode + (this.networkInterfaceId() == null ? 0 : this.networkInterfaceId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MountTargetDescription)) {
            return false;
        }
        MountTargetDescription other = (MountTargetDescription)obj;
        if (other.ownerId() == null ^ this.ownerId() == null) {
            return false;
        }
        if (other.ownerId() != null && !other.ownerId().equals(this.ownerId())) {
            return false;
        }
        if (other.mountTargetId() == null ^ this.mountTargetId() == null) {
            return false;
        }
        if (other.mountTargetId() != null && !other.mountTargetId().equals(this.mountTargetId())) {
            return false;
        }
        if (other.fileSystemId() == null ^ this.fileSystemId() == null) {
            return false;
        }
        if (other.fileSystemId() != null && !other.fileSystemId().equals(this.fileSystemId())) {
            return false;
        }
        if (other.subnetId() == null ^ this.subnetId() == null) {
            return false;
        }
        if (other.subnetId() != null && !other.subnetId().equals(this.subnetId())) {
            return false;
        }
        if (other.lifeCycleStateString() == null ^ this.lifeCycleStateString() == null) {
            return false;
        }
        if (other.lifeCycleStateString() != null && !other.lifeCycleStateString().equals(this.lifeCycleStateString())) {
            return false;
        }
        if (other.ipAddress() == null ^ this.ipAddress() == null) {
            return false;
        }
        if (other.ipAddress() != null && !other.ipAddress().equals(this.ipAddress())) {
            return false;
        }
        if (other.networkInterfaceId() == null ^ this.networkInterfaceId() == null) {
            return false;
        }
        return other.networkInterfaceId() == null || other.networkInterfaceId().equals(this.networkInterfaceId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.ownerId() != null) {
            sb.append("OwnerId: ").append(this.ownerId()).append(",");
        }
        if (this.mountTargetId() != null) {
            sb.append("MountTargetId: ").append(this.mountTargetId()).append(",");
        }
        if (this.fileSystemId() != null) {
            sb.append("FileSystemId: ").append(this.fileSystemId()).append(",");
        }
        if (this.subnetId() != null) {
            sb.append("SubnetId: ").append(this.subnetId()).append(",");
        }
        if (this.lifeCycleStateString() != null) {
            sb.append("LifeCycleState: ").append(this.lifeCycleStateString()).append(",");
        }
        if (this.ipAddress() != null) {
            sb.append("IpAddress: ").append(this.ipAddress()).append(",");
        }
        if (this.networkInterfaceId() != null) {
            sb.append("NetworkInterfaceId: ").append(this.networkInterfaceId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OwnerId": {
                return Optional.of(clazz.cast(this.ownerId()));
            }
            case "MountTargetId": {
                return Optional.of(clazz.cast(this.mountTargetId()));
            }
            case "FileSystemId": {
                return Optional.of(clazz.cast(this.fileSystemId()));
            }
            case "SubnetId": {
                return Optional.of(clazz.cast(this.subnetId()));
            }
            case "LifeCycleState": {
                return Optional.of(clazz.cast(this.lifeCycleStateString()));
            }
            case "IpAddress": {
                return Optional.of(clazz.cast(this.ipAddress()));
            }
            case "NetworkInterfaceId": {
                return Optional.of(clazz.cast(this.networkInterfaceId()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MountTargetDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String ownerId;
        private String mountTargetId;
        private String fileSystemId;
        private String subnetId;
        private String lifeCycleState;
        private String ipAddress;
        private String networkInterfaceId;

        private BuilderImpl() {
        }

        private BuilderImpl(MountTargetDescription model) {
            this.ownerId(model.ownerId);
            this.mountTargetId(model.mountTargetId);
            this.fileSystemId(model.fileSystemId);
            this.subnetId(model.subnetId);
            this.lifeCycleState(model.lifeCycleState);
            this.ipAddress(model.ipAddress);
            this.networkInterfaceId(model.networkInterfaceId);
        }

        public final String getOwnerId() {
            return this.ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        public final String getMountTargetId() {
            return this.mountTargetId;
        }

        @Override
        public final Builder mountTargetId(String mountTargetId) {
            this.mountTargetId = mountTargetId;
            return this;
        }

        public final void setMountTargetId(String mountTargetId) {
            this.mountTargetId = mountTargetId;
        }

        public final String getFileSystemId() {
            return this.fileSystemId;
        }

        @Override
        public final Builder fileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
            return this;
        }

        public final void setFileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
        }

        public final String getSubnetId() {
            return this.subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        public final String getLifeCycleState() {
            return this.lifeCycleState;
        }

        @Override
        public final Builder lifeCycleState(String lifeCycleState) {
            this.lifeCycleState = lifeCycleState;
            return this;
        }

        @Override
        public final Builder lifeCycleState(LifeCycleState lifeCycleState) {
            this.lifeCycleState(lifeCycleState.toString());
            return this;
        }

        public final void setLifeCycleState(String lifeCycleState) {
            this.lifeCycleState = lifeCycleState;
        }

        public final String getIpAddress() {
            return this.ipAddress;
        }

        @Override
        public final Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public final void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        public final String getNetworkInterfaceId() {
            return this.networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        public MountTargetDescription build() {
            return new MountTargetDescription(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, MountTargetDescription> {
        public Builder ownerId(String var1);

        public Builder mountTargetId(String var1);

        public Builder fileSystemId(String var1);

        public Builder subnetId(String var1);

        public Builder lifeCycleState(String var1);

        public Builder lifeCycleState(LifeCycleState var1);

        public Builder ipAddress(String var1);

        public Builder networkInterfaceId(String var1);
    }
}

