/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.efs.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeMountTargetsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeMountTargetsRequest> {
    private final Integer maxItems;
    private final String marker;
    private final String fileSystemId;
    private final String mountTargetId;

    private DescribeMountTargetsRequest(BuilderImpl builder) {
        this.maxItems = builder.maxItems;
        this.marker = builder.marker;
        this.fileSystemId = builder.fileSystemId;
        this.mountTargetId = builder.mountTargetId;
    }

    public Integer maxItems() {
        return this.maxItems;
    }

    public String marker() {
        return this.marker;
    }

    public String fileSystemId() {
        return this.fileSystemId;
    }

    public String mountTargetId() {
        return this.mountTargetId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.maxItems() == null ? 0 : this.maxItems().hashCode());
        hashCode = 31 * hashCode + (this.marker() == null ? 0 : this.marker().hashCode());
        hashCode = 31 * hashCode + (this.fileSystemId() == null ? 0 : this.fileSystemId().hashCode());
        hashCode = 31 * hashCode + (this.mountTargetId() == null ? 0 : this.mountTargetId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMountTargetsRequest)) {
            return false;
        }
        DescribeMountTargetsRequest other = (DescribeMountTargetsRequest)((Object)obj);
        if (other.maxItems() == null ^ this.maxItems() == null) {
            return false;
        }
        if (other.maxItems() != null && !other.maxItems().equals(this.maxItems())) {
            return false;
        }
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        if (other.marker() != null && !other.marker().equals(this.marker())) {
            return false;
        }
        if (other.fileSystemId() == null ^ this.fileSystemId() == null) {
            return false;
        }
        if (other.fileSystemId() != null && !other.fileSystemId().equals(this.fileSystemId())) {
            return false;
        }
        if (other.mountTargetId() == null ^ this.mountTargetId() == null) {
            return false;
        }
        return other.mountTargetId() == null || other.mountTargetId().equals(this.mountTargetId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.maxItems() != null) {
            sb.append("MaxItems: ").append(this.maxItems()).append(",");
        }
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        if (this.fileSystemId() != null) {
            sb.append("FileSystemId: ").append(this.fileSystemId()).append(",");
        }
        if (this.mountTargetId() != null) {
            sb.append("MountTargetId: ").append(this.mountTargetId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MaxItems": {
                return Optional.of(clazz.cast(this.maxItems()));
            }
            case "Marker": {
                return Optional.of(clazz.cast(this.marker()));
            }
            case "FileSystemId": {
                return Optional.of(clazz.cast(this.fileSystemId()));
            }
            case "MountTargetId": {
                return Optional.of(clazz.cast(this.mountTargetId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private Integer maxItems;
        private String marker;
        private String fileSystemId;
        private String mountTargetId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMountTargetsRequest model) {
            this.maxItems(model.maxItems);
            this.marker(model.marker);
            this.fileSystemId(model.fileSystemId);
            this.mountTargetId(model.mountTargetId);
        }

        public final Integer getMaxItems() {
            return this.maxItems;
        }

        @Override
        public final Builder maxItems(Integer maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final void setMaxItems(Integer maxItems) {
            this.maxItems = maxItems;
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final String getFileSystemId() {
            return this.fileSystemId;
        }

        @Override
        public final Builder fileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
            return this;
        }

        public final void setFileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
        }

        public final String getMountTargetId() {
            return this.mountTargetId;
        }

        @Override
        public final Builder mountTargetId(String mountTargetId) {
            this.mountTargetId = mountTargetId;
            return this;
        }

        public final void setMountTargetId(String mountTargetId) {
            this.mountTargetId = mountTargetId;
        }

        public DescribeMountTargetsRequest build() {
            return new DescribeMountTargetsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeMountTargetsRequest> {
        public Builder maxItems(Integer var1);

        public Builder marker(String var1);

        public Builder fileSystemId(String var1);

        public Builder mountTargetId(String var1);
    }
}

