/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.efs.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.efs.model.PerformanceMode;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateFileSystemRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreateFileSystemRequest> {
    private final String creationToken;
    private final String performanceMode;

    private CreateFileSystemRequest(BuilderImpl builder) {
        this.creationToken = builder.creationToken;
        this.performanceMode = builder.performanceMode;
    }

    public String creationToken() {
        return this.creationToken;
    }

    public PerformanceMode performanceMode() {
        return PerformanceMode.fromValue(this.performanceMode);
    }

    public String performanceModeString() {
        return this.performanceMode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.creationToken() == null ? 0 : this.creationToken().hashCode());
        hashCode = 31 * hashCode + (this.performanceModeString() == null ? 0 : this.performanceModeString().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFileSystemRequest)) {
            return false;
        }
        CreateFileSystemRequest other = (CreateFileSystemRequest)((Object)obj);
        if (other.creationToken() == null ^ this.creationToken() == null) {
            return false;
        }
        if (other.creationToken() != null && !other.creationToken().equals(this.creationToken())) {
            return false;
        }
        if (other.performanceModeString() == null ^ this.performanceModeString() == null) {
            return false;
        }
        return other.performanceModeString() == null || other.performanceModeString().equals(this.performanceModeString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.creationToken() != null) {
            sb.append("CreationToken: ").append(this.creationToken()).append(",");
        }
        if (this.performanceModeString() != null) {
            sb.append("PerformanceMode: ").append(this.performanceModeString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CreationToken": {
                return Optional.of(clazz.cast(this.creationToken()));
            }
            case "PerformanceMode": {
                return Optional.of(clazz.cast(this.performanceModeString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String creationToken;
        private String performanceMode;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFileSystemRequest model) {
            this.creationToken(model.creationToken);
            this.performanceMode(model.performanceMode);
        }

        public final String getCreationToken() {
            return this.creationToken;
        }

        @Override
        public final Builder creationToken(String creationToken) {
            this.creationToken = creationToken;
            return this;
        }

        public final void setCreationToken(String creationToken) {
            this.creationToken = creationToken;
        }

        public final String getPerformanceMode() {
            return this.performanceMode;
        }

        @Override
        public final Builder performanceMode(String performanceMode) {
            this.performanceMode = performanceMode;
            return this;
        }

        @Override
        public final Builder performanceMode(PerformanceMode performanceMode) {
            this.performanceMode(performanceMode.toString());
            return this;
        }

        public final void setPerformanceMode(String performanceMode) {
            this.performanceMode = performanceMode;
        }

        public CreateFileSystemRequest build() {
            return new CreateFileSystemRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateFileSystemRequest> {
        public Builder creationToken(String var1);

        public Builder performanceMode(String var1);

        public Builder performanceMode(PerformanceMode var1);
    }
}

