/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.efs.transform;

import java.util.List;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.efs.model.CreateTagsRequest;

@SdkInternalApi
public class CreateTagsRequestModelMarshaller {
    private static final MarshallingInfo<String> FILESYSTEMID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("FileSystemId").build();
    private static final MarshallingInfo<List> TAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Tags").build();
    private static final CreateTagsRequestModelMarshaller INSTANCE = new CreateTagsRequestModelMarshaller();

    public static CreateTagsRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CreateTagsRequest createTagsRequest, ProtocolMarshaller protocolMarshaller) {
        if (createTagsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)createTagsRequest.fileSystemId(), FILESYSTEMID_BINDING);
            protocolMarshaller.marshall(createTagsRequest.tags(), TAGS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

