/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.efs.transform;

import com.fasterxml.jackson.core.JsonToken;
import java.time.Instant;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.efs.model.FileSystemDescription;
import software.amazon.awssdk.services.efs.transform.FileSystemSizeUnmarshaller;

public class FileSystemDescriptionUnmarshaller
implements Unmarshaller<FileSystemDescription, JsonUnmarshallerContext> {
    private static final FileSystemDescriptionUnmarshaller INSTANCE = new FileSystemDescriptionUnmarshaller();

    public FileSystemDescription unmarshall(JsonUnmarshallerContext context) throws Exception {
        FileSystemDescription.Builder fileSystemDescriptionBuilder = FileSystemDescription.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("OwnerId", targetDepth)) {
                    context.nextToken();
                    fileSystemDescriptionBuilder.ownerId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("CreationToken", targetDepth)) {
                    context.nextToken();
                    fileSystemDescriptionBuilder.creationToken((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("FileSystemId", targetDepth)) {
                    context.nextToken();
                    fileSystemDescriptionBuilder.fileSystemId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("CreationTime", targetDepth)) {
                    context.nextToken();
                    fileSystemDescriptionBuilder.creationTime((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("LifeCycleState", targetDepth)) {
                    context.nextToken();
                    fileSystemDescriptionBuilder.lifeCycleState((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Name", targetDepth)) {
                    context.nextToken();
                    fileSystemDescriptionBuilder.name((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("NumberOfMountTargets", targetDepth)) {
                    context.nextToken();
                    fileSystemDescriptionBuilder.numberOfMountTargets((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("SizeInBytes", targetDepth)) {
                    context.nextToken();
                    fileSystemDescriptionBuilder.sizeInBytes(FileSystemSizeUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("PerformanceMode", targetDepth)) {
                    context.nextToken();
                    fileSystemDescriptionBuilder.performanceMode((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (FileSystemDescription)fileSystemDescriptionBuilder.build();
    }

    public static FileSystemDescriptionUnmarshaller getInstance() {
        return INSTANCE;
    }
}

