/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.efs;

import software.amazon.awssdk.AmazonServiceException;
import software.amazon.awssdk.SdkBaseException;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.client.AwsSyncClientParams;
import software.amazon.awssdk.client.ClientExecutionParams;
import software.amazon.awssdk.client.ClientHandler;
import software.amazon.awssdk.client.ClientHandlerParams;
import software.amazon.awssdk.client.SdkClientHandler;
import software.amazon.awssdk.http.HttpResponseHandler;
import software.amazon.awssdk.protocol.json.JsonClientMetadata;
import software.amazon.awssdk.protocol.json.JsonErrorResponseMetadata;
import software.amazon.awssdk.protocol.json.JsonErrorShapeMetadata;
import software.amazon.awssdk.protocol.json.JsonOperationMetadata;
import software.amazon.awssdk.protocol.json.SdkJsonProtocolFactory;
import software.amazon.awssdk.runtime.http.response.JsonResponseHandler;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.efs.EFSClient;
import software.amazon.awssdk.services.efs.model.BadRequestException;
import software.amazon.awssdk.services.efs.model.CreateFileSystemRequest;
import software.amazon.awssdk.services.efs.model.CreateFileSystemResponse;
import software.amazon.awssdk.services.efs.model.CreateMountTargetRequest;
import software.amazon.awssdk.services.efs.model.CreateMountTargetResponse;
import software.amazon.awssdk.services.efs.model.CreateTagsRequest;
import software.amazon.awssdk.services.efs.model.CreateTagsResponse;
import software.amazon.awssdk.services.efs.model.DeleteFileSystemRequest;
import software.amazon.awssdk.services.efs.model.DeleteFileSystemResponse;
import software.amazon.awssdk.services.efs.model.DeleteMountTargetRequest;
import software.amazon.awssdk.services.efs.model.DeleteMountTargetResponse;
import software.amazon.awssdk.services.efs.model.DeleteTagsRequest;
import software.amazon.awssdk.services.efs.model.DeleteTagsResponse;
import software.amazon.awssdk.services.efs.model.DependencyTimeoutException;
import software.amazon.awssdk.services.efs.model.DescribeFileSystemsRequest;
import software.amazon.awssdk.services.efs.model.DescribeFileSystemsResponse;
import software.amazon.awssdk.services.efs.model.DescribeMountTargetSecurityGroupsRequest;
import software.amazon.awssdk.services.efs.model.DescribeMountTargetSecurityGroupsResponse;
import software.amazon.awssdk.services.efs.model.DescribeMountTargetsRequest;
import software.amazon.awssdk.services.efs.model.DescribeMountTargetsResponse;
import software.amazon.awssdk.services.efs.model.DescribeTagsRequest;
import software.amazon.awssdk.services.efs.model.DescribeTagsResponse;
import software.amazon.awssdk.services.efs.model.EFSException;
import software.amazon.awssdk.services.efs.model.FileSystemAlreadyExistsException;
import software.amazon.awssdk.services.efs.model.FileSystemInUseException;
import software.amazon.awssdk.services.efs.model.FileSystemLimitExceededException;
import software.amazon.awssdk.services.efs.model.FileSystemNotFoundException;
import software.amazon.awssdk.services.efs.model.IncorrectFileSystemLifeCycleStateException;
import software.amazon.awssdk.services.efs.model.IncorrectMountTargetStateException;
import software.amazon.awssdk.services.efs.model.InternalServerErrorException;
import software.amazon.awssdk.services.efs.model.IpAddressInUseException;
import software.amazon.awssdk.services.efs.model.ModifyMountTargetSecurityGroupsRequest;
import software.amazon.awssdk.services.efs.model.ModifyMountTargetSecurityGroupsResponse;
import software.amazon.awssdk.services.efs.model.MountTargetConflictException;
import software.amazon.awssdk.services.efs.model.MountTargetNotFoundException;
import software.amazon.awssdk.services.efs.model.NetworkInterfaceLimitExceededException;
import software.amazon.awssdk.services.efs.model.NoFreeAddressesInSubnetException;
import software.amazon.awssdk.services.efs.model.SecurityGroupLimitExceededException;
import software.amazon.awssdk.services.efs.model.SecurityGroupNotFoundException;
import software.amazon.awssdk.services.efs.model.SubnetNotFoundException;
import software.amazon.awssdk.services.efs.model.UnsupportedAvailabilityZoneException;
import software.amazon.awssdk.services.efs.transform.CreateFileSystemRequestMarshaller;
import software.amazon.awssdk.services.efs.transform.CreateFileSystemResponseUnmarshaller;
import software.amazon.awssdk.services.efs.transform.CreateMountTargetRequestMarshaller;
import software.amazon.awssdk.services.efs.transform.CreateMountTargetResponseUnmarshaller;
import software.amazon.awssdk.services.efs.transform.CreateTagsRequestMarshaller;
import software.amazon.awssdk.services.efs.transform.CreateTagsResponseUnmarshaller;
import software.amazon.awssdk.services.efs.transform.DeleteFileSystemRequestMarshaller;
import software.amazon.awssdk.services.efs.transform.DeleteFileSystemResponseUnmarshaller;
import software.amazon.awssdk.services.efs.transform.DeleteMountTargetRequestMarshaller;
import software.amazon.awssdk.services.efs.transform.DeleteMountTargetResponseUnmarshaller;
import software.amazon.awssdk.services.efs.transform.DeleteTagsRequestMarshaller;
import software.amazon.awssdk.services.efs.transform.DeleteTagsResponseUnmarshaller;
import software.amazon.awssdk.services.efs.transform.DescribeFileSystemsRequestMarshaller;
import software.amazon.awssdk.services.efs.transform.DescribeFileSystemsResponseUnmarshaller;
import software.amazon.awssdk.services.efs.transform.DescribeMountTargetSecurityGroupsRequestMarshaller;
import software.amazon.awssdk.services.efs.transform.DescribeMountTargetSecurityGroupsResponseUnmarshaller;
import software.amazon.awssdk.services.efs.transform.DescribeMountTargetsRequestMarshaller;
import software.amazon.awssdk.services.efs.transform.DescribeMountTargetsResponseUnmarshaller;
import software.amazon.awssdk.services.efs.transform.DescribeTagsRequestMarshaller;
import software.amazon.awssdk.services.efs.transform.DescribeTagsResponseUnmarshaller;
import software.amazon.awssdk.services.efs.transform.ModifyMountTargetSecurityGroupsRequestMarshaller;
import software.amazon.awssdk.services.efs.transform.ModifyMountTargetSecurityGroupsResponseUnmarshaller;

@SdkInternalApi
final class DefaultEFSClient
implements EFSClient {
    private final ClientHandler clientHandler;
    private final SdkJsonProtocolFactory protocolFactory;
    private final AwsSyncClientParams clientParams;

    protected DefaultEFSClient(AwsSyncClientParams clientParams) {
        this.clientHandler = new SdkClientHandler(new ClientHandlerParams().withClientParams(clientParams).withCalculateCrc32FromCompressedDataEnabled(false));
        this.clientParams = clientParams;
        this.protocolFactory = this.init();
    }

    @Override
    public CreateFileSystemResponse createFileSystem(CreateFileSystemRequest createFileSystemRequest) throws BadRequestException, InternalServerErrorException, FileSystemAlreadyExistsException, FileSystemLimitExceededException, SdkBaseException, SdkClientException, EFSException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new CreateFileSystemResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (CreateFileSystemResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)createFileSystemRequest).withMarshaller((Marshaller)new CreateFileSystemRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public CreateMountTargetResponse createMountTarget(CreateMountTargetRequest createMountTargetRequest) throws BadRequestException, InternalServerErrorException, FileSystemNotFoundException, IncorrectFileSystemLifeCycleStateException, MountTargetConflictException, SubnetNotFoundException, NoFreeAddressesInSubnetException, IpAddressInUseException, NetworkInterfaceLimitExceededException, SecurityGroupLimitExceededException, SecurityGroupNotFoundException, UnsupportedAvailabilityZoneException, SdkBaseException, SdkClientException, EFSException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new CreateMountTargetResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (CreateMountTargetResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)createMountTargetRequest).withMarshaller((Marshaller)new CreateMountTargetRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public CreateTagsResponse createTags(CreateTagsRequest createTagsRequest) throws BadRequestException, InternalServerErrorException, FileSystemNotFoundException, SdkBaseException, SdkClientException, EFSException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new CreateTagsResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (CreateTagsResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)createTagsRequest).withMarshaller((Marshaller)new CreateTagsRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public DeleteFileSystemResponse deleteFileSystem(DeleteFileSystemRequest deleteFileSystemRequest) throws BadRequestException, InternalServerErrorException, FileSystemNotFoundException, FileSystemInUseException, SdkBaseException, SdkClientException, EFSException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new DeleteFileSystemResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DeleteFileSystemResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)deleteFileSystemRequest).withMarshaller((Marshaller)new DeleteFileSystemRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public DeleteMountTargetResponse deleteMountTarget(DeleteMountTargetRequest deleteMountTargetRequest) throws BadRequestException, InternalServerErrorException, DependencyTimeoutException, MountTargetNotFoundException, SdkBaseException, SdkClientException, EFSException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new DeleteMountTargetResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DeleteMountTargetResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)deleteMountTargetRequest).withMarshaller((Marshaller)new DeleteMountTargetRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public DeleteTagsResponse deleteTags(DeleteTagsRequest deleteTagsRequest) throws BadRequestException, InternalServerErrorException, FileSystemNotFoundException, SdkBaseException, SdkClientException, EFSException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new DeleteTagsResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DeleteTagsResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)deleteTagsRequest).withMarshaller((Marshaller)new DeleteTagsRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public DescribeFileSystemsResponse describeFileSystems() throws BadRequestException, InternalServerErrorException, FileSystemNotFoundException, SdkBaseException, SdkClientException, EFSException {
        return this.describeFileSystems((DescribeFileSystemsRequest)((Object)DescribeFileSystemsRequest.builder().build()));
    }

    @Override
    public DescribeFileSystemsResponse describeFileSystems(DescribeFileSystemsRequest describeFileSystemsRequest) throws BadRequestException, InternalServerErrorException, FileSystemNotFoundException, SdkBaseException, SdkClientException, EFSException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new DescribeFileSystemsResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DescribeFileSystemsResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)describeFileSystemsRequest).withMarshaller((Marshaller)new DescribeFileSystemsRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public DescribeMountTargetSecurityGroupsResponse describeMountTargetSecurityGroups(DescribeMountTargetSecurityGroupsRequest describeMountTargetSecurityGroupsRequest) throws BadRequestException, InternalServerErrorException, MountTargetNotFoundException, IncorrectMountTargetStateException, SdkBaseException, SdkClientException, EFSException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new DescribeMountTargetSecurityGroupsResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DescribeMountTargetSecurityGroupsResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)describeMountTargetSecurityGroupsRequest).withMarshaller((Marshaller)new DescribeMountTargetSecurityGroupsRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public DescribeMountTargetsResponse describeMountTargets(DescribeMountTargetsRequest describeMountTargetsRequest) throws BadRequestException, InternalServerErrorException, FileSystemNotFoundException, MountTargetNotFoundException, SdkBaseException, SdkClientException, EFSException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new DescribeMountTargetsResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DescribeMountTargetsResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)describeMountTargetsRequest).withMarshaller((Marshaller)new DescribeMountTargetsRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public DescribeTagsResponse describeTags(DescribeTagsRequest describeTagsRequest) throws BadRequestException, InternalServerErrorException, FileSystemNotFoundException, SdkBaseException, SdkClientException, EFSException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new DescribeTagsResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DescribeTagsResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)describeTagsRequest).withMarshaller((Marshaller)new DescribeTagsRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public ModifyMountTargetSecurityGroupsResponse modifyMountTargetSecurityGroups(ModifyMountTargetSecurityGroupsRequest modifyMountTargetSecurityGroupsRequest) throws BadRequestException, InternalServerErrorException, MountTargetNotFoundException, IncorrectMountTargetStateException, SecurityGroupLimitExceededException, SecurityGroupNotFoundException, SdkBaseException, SdkClientException, EFSException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new ModifyMountTargetSecurityGroupsResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (ModifyMountTargetSecurityGroupsResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)modifyMountTargetSecurityGroupsRequest).withMarshaller((Marshaller)new ModifyMountTargetSecurityGroupsRequestMarshaller(this.protocolFactory))));
    }

    private HttpResponseHandler<AmazonServiceException> createErrorResponseHandler() {
        return this.protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
    }

    private SdkJsonProtocolFactory init() {
        return new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withBaseServiceExceptionClass(EFSException.class).withContentTypeOverride("").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("MountTargetNotFound").withModeledClass(MountTargetNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("SubnetNotFound").withModeledClass(SubnetNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("IncorrectMountTargetState").withModeledClass(IncorrectMountTargetStateException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("UnsupportedAvailabilityZone").withModeledClass(UnsupportedAvailabilityZoneException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("IpAddressInUse").withModeledClass(IpAddressInUseException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("MountTargetConflict").withModeledClass(MountTargetConflictException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("SecurityGroupNotFound").withModeledClass(SecurityGroupNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("FileSystemInUse").withModeledClass(FileSystemInUseException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("FileSystemAlreadyExists").withModeledClass(FileSystemAlreadyExistsException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("SecurityGroupLimitExceeded").withModeledClass(SecurityGroupLimitExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("NetworkInterfaceLimitExceeded").withModeledClass(NetworkInterfaceLimitExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("IncorrectFileSystemLifeCycleState").withModeledClass(IncorrectFileSystemLifeCycleStateException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("DependencyTimeout").withModeledClass(DependencyTimeoutException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("NoFreeAddressesInSubnet").withModeledClass(NoFreeAddressesInSubnetException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("FileSystemLimitExceeded").withModeledClass(FileSystemLimitExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("FileSystemNotFound").withModeledClass(FileSystemNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("BadRequest").withModeledClass(BadRequestException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerError").withModeledClass(InternalServerErrorException.class)));
    }

    @Override
    public void close() throws Exception {
        this.clientHandler.close();
    }
}

