/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.efs.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.efs.model.CreateFileSystemRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CreateFileSystemRequestModelMarshaller {
    private static final MarshallingInfo<String> CREATIONTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationToken").isBinary(false).build();
    private static final MarshallingInfo<String> PERFORMANCEMODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PerformanceMode").isBinary(false).build();
    private static final MarshallingInfo<Boolean> ENCRYPTED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Encrypted").isBinary(false).build();
    private static final MarshallingInfo<String> KMSKEYID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KmsKeyId").isBinary(false).build();
    private static final MarshallingInfo<String> THROUGHPUTMODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ThroughputMode").isBinary(false).build();
    private static final MarshallingInfo<Double> PROVISIONEDTHROUGHPUTINMIBPS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProvisionedThroughputInMibps").isBinary(false).build();
    private static final CreateFileSystemRequestModelMarshaller INSTANCE = new CreateFileSystemRequestModelMarshaller();

    private CreateFileSystemRequestModelMarshaller() {
    }

    public static CreateFileSystemRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CreateFileSystemRequest createFileSystemRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)createFileSystemRequest), (String)"createFileSystemRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)createFileSystemRequest.creationToken(), CREATIONTOKEN_BINDING);
            protocolMarshaller.marshall((Object)createFileSystemRequest.performanceModeAsString(), PERFORMANCEMODE_BINDING);
            protocolMarshaller.marshall((Object)createFileSystemRequest.encrypted(), ENCRYPTED_BINDING);
            protocolMarshaller.marshall((Object)createFileSystemRequest.kmsKeyId(), KMSKEYID_BINDING);
            protocolMarshaller.marshall((Object)createFileSystemRequest.throughputModeAsString(), THROUGHPUTMODE_BINDING);
            protocolMarshaller.marshall((Object)createFileSystemRequest.provisionedThroughputInMibps(), PROVISIONEDTHROUGHPUTINMIBPS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

